/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.override;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.orifu.skin_overrides.Library;
import net.orifu.skin_overrides.Mod;
import net.orifu.skin_overrides.OverrideManager;
import net.orifu.skin_overrides.Skin;
import net.orifu.skin_overrides.library.SkinLibrary;
import net.orifu.skin_overrides.profile.Profile;
import net.orifu.skin_overrides.util.Util;
import org.jetbrains.annotations.Nullable;

public class LibraryOverrider
implements OverrideManager.Overrider {
    protected final Library library;
    protected final String rootFolder;

    public LibraryOverrider(Library library, String rootFolder) {
        this.library = library;
        this.rootFolder = rootFolder;
    }

    @Override
    public final String fileName(Profile profile, @Nullable Skin.Model model) {
        return profile.stableId() + ".txt";
    }

    @Override
    public Optional<OverrideManager.Override> get(File file, String name, String ext) {
        if (ext.equals("txt")) {
            return Util.readFile(file).flatMap(id -> Optional.ofNullable(class_2960.method_12829((String)id))).filter(id -> id.method_12836().equals("skin_overrides")).flatMap(id -> this.library.get(id.method_12832()).map(entry -> new LibraryOverride(name, (Library.LibraryEntry)entry)));
        }
        return Optional.empty();
    }

    public void addOverride(Profile profile, Library.LibraryEntry entry) {
        Path outputPath = Paths.get(this.rootFolder, this.fileName(profile, null));
        try {
            BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(Mod.id(entry.getId()).toString());
            writer.close();
        }
        catch (IOException e) {
            Mod.LOGGER.error("failed to save library entry with id {} to file", (Object)entry.getId(), (Object)e);
        }
    }

    public record LibraryOverride(String playerIdent, Library.LibraryEntry entry) implements OverrideManager.Override
    {
        @Override
        public class_2960 texture() {
            return this.entry.getTexture();
        }

        @Override
        @Nullable
        public File texturePath() {
            return this.entry.texturePath();
        }

        @Override
        @Nullable
        public Skin.Model model() {
            Library.LibraryEntry libraryEntry = this.entry;
            if (libraryEntry instanceof SkinLibrary.SkinEntry) {
                SkinLibrary.SkinEntry skinEntry = (SkinLibrary.SkinEntry)libraryEntry;
                return skinEntry.getModel();
            }
            return null;
        }

        @Override
        public class_2561 info() {
            return class_2561.method_43469((String)"skin_overrides.override.library", (Object[])new Object[]{this.entry.getName()});
        }

        @Override
        public CompletableFuture<Optional<Skin.Signature>> signature() {
            Library.LibraryEntry libraryEntry = this.entry;
            if (!(libraryEntry instanceof SkinLibrary.SkinEntry)) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            SkinLibrary.SkinEntry skinEntry = (SkinLibrary.SkinEntry)libraryEntry;
            return skinEntry.signed().thenApply(signed -> {
                signed.ifPresent(newEntry -> SkinLibrary.INSTANCE.replace(this.entry, (Library.LibraryEntry)newEntry));
                return signed.map(s -> s.signature);
            });
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LibraryOverride)) {
                return false;
            }
            LibraryOverride that = (LibraryOverride)o;
            return Objects.equals(this.playerIdent, that.playerIdent) && Objects.equals(this.entry, that.entry);
        }
    }
}

