/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.skin_overrides.util;

import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.orifu.skin_overrides.Mod;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final String UUID_REGEX = "[0-9a-fA-F]{8}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{12}";

    public static Optional<String> readFile(File file) {
        try {
            return Optional.of(Files.readString(file.toPath()).trim()).flatMap(content -> content.isEmpty() ? Optional.empty() : Optional.of(content));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> readString(@Nullable JsonObject obj, String key) {
        if (obj == null || !obj.has(key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(obj.get(key).getAsString());
    }

    public static String hashFile(File file) {
        return file.length() + "-" + file.lastModified();
    }

    public static Optional<UUID> asUuid(String s) {
        if (s.matches(UUID_REGEX)) {
            try {
                UUID uuid = UUIDTypeAdapter.fromString((String)s);
                return Optional.of(uuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static String randomId() {
        return UUID.randomUUID().toString();
    }

    public static String seededId(String seed) {
        return UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8)).toString();
    }

    public static Optional<File> nameTempFile() {
        try {
            File file = File.createTempFile("skin-overrides_", "_temp");
            if (!file.delete()) {
                return Optional.empty();
            }
            return Optional.of(file);
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }

    public static Executor ioPool() {
        return class_156.method_27958();
    }

    @Nullable
    public static <T> T tryGet(CompletableFuture<T> future) {
        try {
            return future.isDone() ? (T)future.get() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    public static void saveTexture(class_2960 texture, int w, int h, Path path) {
        CompletableFuture future = new CompletableFuture();
        Util.saveTexture(texture, w, h).thenAccept(img -> {
            Util.saveImage(img, path);
            future.complete(path);
        });
    }

    public static void saveImage(class_1011 img, Path path) {
        try {
            img.method_4314(path);
            img.close();
        }
        catch (IOException e) {
            Mod.LOGGER.error("failed to save image to path {}", (Object)path, (Object)e);
        }
    }

    public static CompletableFuture<class_1011> saveTexture(class_2960 texture, int w, int h) {
        CompletableFuture<class_1011> future = new CompletableFuture<class_1011>();
        CompletableFuture.runAsync(() -> {
            class_310.method_1551().method_1531().method_22813(texture);
            class_1011 img = new class_1011(w, h, false);
            img.method_4327(0, false);
            future.complete(img);
        }, (Executor)class_310.method_1551());
        return future;
    }
}

