package dev.imb11.shields.compat.eiv;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import dev.imb11.shields.Shields;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class AnvilServerRecipe implements IEivServerRecipe {

    public static final EivRecipeType<AnvilServerRecipe> TYPE = EivRecipeType.register(
            class_2960.method_60655(Shields.MOD_ID,"anvil_combining"),
            () -> new AnvilServerRecipe(null, null, null)
    );
    private class_1799 left;
    private class_1799 right;
    private class_1799 result;

    public AnvilServerRecipe(class_1799 left, class_1799 right, class_1799 result) {
        this.left = left;
        this.right = right;
        this.result = result;
    }


    @Override
    public void writeToTag(class_2487 tag) {
        tag.method_10566("left", EivTagUtil.encodeItemStackOnServer(left));
        tag.method_10566("right", EivTagUtil.encodeItemStackOnServer(right));
        tag.method_10566("result",  EivTagUtil.encodeItemStackOnServer(result));
    }

    @Override
    public void loadFromTag(class_2487 tag) {
        left = EivTagUtil.decodeItemStackOnClient(tag.method_68568("left"));
        right = EivTagUtil.decodeItemStackOnClient(tag.method_68568("right"));
        result =  EivTagUtil.decodeItemStackOnClient(tag.method_68568("result"));
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }

    public class_1799 getLeft() {
        return left;
    }

    public class_1799 getRight() {
        return right;
    }

    public class_1799 getResult() {
        return result;
    }
}