//? fabric {
package dev.imb11.shields.datagen.providers;

import dev.imb11.shields.client.ShieldsClient;
import dev.imb11.shields.datagen.data.ShieldsAtlas;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricCodecDataProvider;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class ShieldsAtlasProvider extends FabricCodecDataProvider<ShieldsAtlas> {
    public ShieldsAtlasProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(dataOutput, registriesFuture, class_7784.class_7490.field_39368, "atlases", ShieldsAtlas.CODEC);
    }

    @Override
    protected void configure(BiConsumer<class_2960, ShieldsAtlas> biConsumer, class_7225.class_7874 provider) {
        ArrayList<class_4730> materials = new ArrayList<>();
        ShieldsClient.REGISTERED_MATERIALS.values().forEach(materials::addAll);
        var shieldsAtlas = new ShieldsAtlas(materials.stream().map(material -> new ShieldsAtlas.Source("single", material.method_24147().toString())).toList());
        biConsumer.accept(class_2960.method_12829("blocks"), shieldsAtlas);
    }

    @Override
    public String method_10321() {
        return "Extra Shields Atlas";
    }
}
//?}