//? fabric {
package dev.imb11.shields.datagen.providers;

import dev.imb11.shields.enchantments.ShieldsEnchantmentKeys;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1887;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import java.util.concurrent.CompletableFuture;

public class ShieldsEnchantmentProvider extends FabricDynamicRegistryProvider {

    public ShieldsEnchantmentProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void configure(class_7225.class_7874 provider, Entries entries) {
        var enchantmentsLookup = entries.getLookup(class_7924.field_41265);

        register(entries, ShieldsEnchantmentKeys.EVOKERING, new class_1887.class_9700(
                class_1887.method_58442(
                        provider.method_46762(class_7924.field_41197).method_46735(ConventionalItemTags.SHIELD_TOOLS),
                        // Weight (lowest rarity)
                        1,
                        // Max level
                        3,
                        // min cost for each level: 20 + (level - 1)*10
                        class_1887.method_58441(20, 10),
                        // max cost for each level: 45 + (level - 1)*15
                        class_1887.method_58441(45, 15),
                        5,
                        class_9274.field_49219
                )).method_60061(enchantmentsLookup.method_46735(ShieldsEnchantmentTagProvider.EVOKERING_EXCLUSIVE_SET))
        );

        register(entries, ShieldsEnchantmentKeys.LAUNCHING, new class_1887.class_9700(
                class_1887.method_58442(
                        provider.method_46762(class_7924.field_41197).method_46735(ConventionalItemTags.SHIELD_TOOLS),
                        // Weight (less common)
                        5,
                        // Max level
                        3,
                        // min cost for each level: 10 + (level - 1)*5
                        class_1887.method_58441(10, 5),
                        // max cost for each level: 25 + (level - 1)*10
                        class_1887.method_58441(25, 10),
                        5,
                        class_9274.field_49219
                )).method_60061(enchantmentsLookup.method_46735(ShieldsEnchantmentTagProvider.LAUNCHING_EXCLUSIVE_SET))
        );

        register(entries, ShieldsEnchantmentKeys.LIFEBOUND, new class_1887.class_9700(
                class_1887.method_58442(
                        provider.method_46762(class_7924.field_41197).method_46735(ConventionalItemTags.SHIELD_TOOLS),
                        // Weight
                        3,
                        // Max level
                        2,
                        // min cost for each level: 12 + (level - 1)*7
                        class_1887.method_58441(12, 7),
                        // max cost for each level: 30 + (level - 1)*10
                        class_1887.method_58441(30, 10),
                        5,
                        class_9274.field_49219
                )).method_60061(enchantmentsLookup.method_46735(ShieldsEnchantmentTagProvider.LIFEBOUND_EXCLUSIVE_SET))
        );

        register(entries, ShieldsEnchantmentKeys.MOMENTUM, new class_1887.class_9700(
                class_1887.method_58442(
                        provider.method_46762(class_7924.field_41197).method_46735(ConventionalItemTags.SHIELD_TOOLS),
                        // Weight (common)
                        12,
                        // Max level
                        5,
                        // min cost for each level: 5 + (level - 1)*5
                        class_1887.method_58441(5, 5),
                        // max cost for each level: 20 + (level - 1)*8
                        class_1887.method_58441(20, 8),
                        5,
                        class_9274.field_49219
                )).method_60061(enchantmentsLookup.method_46735(ShieldsEnchantmentTagProvider.MOMENTUM_EXCLUSIVE_SET))
        );

        register(entries, ShieldsEnchantmentKeys.BRACING, new class_1887.class_9700(
                class_1887.method_58442(
                        provider.method_46762(class_7924.field_41197).method_46735(ConventionalItemTags.SHIELD_TOOLS),
                        // Weight
                        10,
                        // Max level
                        5,
                        // min cost for each level: 8 + (level - 1)*6
                        class_1887.method_58441(8, 6),
                        // max cost for each level: 25 + (level - 1)*10
                        class_1887.method_58441(25, 10),
                        5,
                        class_9274.field_49219
                )).method_60061(enchantmentsLookup.method_46735(ShieldsEnchantmentTagProvider.BRACING_EXCLUSIVE_SET))
        );
    }

    private void register(Entries entries, class_5321<class_1887> key, class_1887.class_9700 builder, ResourceCondition... resourceConditions) {
        entries.add(key, builder.method_60060(key.method_29177()), resourceConditions);
    }

    @Override
    public String method_10321() {
        return "ExtraShields Enchantment Provider";
    }
}
//?}