//? fabric {
package dev.imb11.shields.datagen.providers;

import dev.imb11.shields.items.BannerShieldItemWrapper;
import dev.imb11.shields.items.ShieldsItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.text.WordUtils;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ShieldsLangProvider extends FabricLanguageProvider {
    public ShieldsLangProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    @Override
    public void generateTranslations(class_7225.class_7874 provider, TranslationBuilder translationBuilder) {
        try {
            Optional<Path> path = dataOutput.getModContainer().findPath("assets/shields/lang/en_us.base.json");

            if (path.isPresent()) {
                translationBuilder.add(path.get());
            } else {
                throw new RuntimeException("The existing language file could not be found in assets!");
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        List<class_1792> dyeItems = class_7923.field_41178.method_10220().filter(item -> item instanceof class_1769).toList();
        Map<class_1767, String> dyeNameMap = dyeItems.stream()
                .map(item -> (class_1769) item)
                .collect(Collectors.toMap(
                        class_1769::method_7802,
                        dyeItem -> WordUtils.capitalize(dyeItem.method_7802().method_7792().replace("_", " ")),
                        (existing, replacement) -> existing
                ));
        Map<BannerShieldItemWrapper, String> shieldNameMap = ShieldsItems.SHIELD_ITEMS.stream()
                .collect(Collectors.toMap(
                        shield -> shield,
                        shield -> WordUtils.capitalize(shield.method_40131().method_40237().method_29177().method_12832().replace("_", " "))
                ));

        for (Map.Entry<BannerShieldItemWrapper, String> bannerShieldItemWrapperStringEntry : shieldNameMap.entrySet()) {
            String shieldID = bannerShieldItemWrapperStringEntry.getKey().method_40131().method_40237().method_29177().method_12832();
            for (Map.Entry<class_1767, String> dyeColorStringEntry : dyeNameMap.entrySet()) {
                String dyeID = dyeColorStringEntry.getKey().method_7792();
                translationBuilder.add("item.shields." + shieldID + "." + dyeID, dyeColorStringEntry.getValue() + " " + bannerShieldItemWrapperStringEntry.getValue());
            }
        }
    }
}
//?}