package dev.imb11.shields.enchantments;

//? fabric
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.minecraft.class_109;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import net.minecraft.world.level.storage.loot.entries.*;

public class ShieldEnchantmentLootHelper {
    private static final class_2960 CHESTS_NETHER_BRIDGE = class_2960.method_60654("chests/nether_bridge");
    private static final class_2960 CHESTS_WOODLAND_MANSION = class_2960.method_60654("chests/woodland_mansion");
    private static final class_2960 CHESTS_OMINOUS_VAULT_RARE = class_2960.method_60654("chests/trial_chambers/reward_ominous_rare");

    //? if fabric {
    public static void modifyLootTables(class_5321<class_52> lootTableResourceKey, class_52.class_53 builder, LootTableSource lootTableSource, class_7225.class_7874 provider) {
        var enchantmentRegistryLookup = provider.method_46762(class_7924.field_41265);

        if (lootTableSource.isBuiltin() && CHESTS_WOODLAND_MANSION.equals(lootTableResourceKey.method_29177())) {
            builder.modifyPools(poolBuilder -> {
              poolBuilder.method_351(class_77.method_411(class_1802.field_8529)
                      .method_437(6)
                      .method_438(new class_109.class_4954().method_25992(
                              enchantmentRegistryLookup.method_46747(ShieldsEnchantmentKeys.EVOKERING)
                      )));
            });
        }

        if (lootTableSource.isBuiltin() && CHESTS_NETHER_BRIDGE.equals(lootTableResourceKey.method_29177())) {
            builder.modifyPools(poolBuilder -> {
              poolBuilder.method_351(class_77.method_411(class_1802.field_8529)
                      .method_437(5)
                      .method_438(new class_109.class_4954().method_25992(
                              enchantmentRegistryLookup.method_46747(ShieldsEnchantmentKeys.LIFEBOUND)
                      )));
            });
        }

        if (lootTableSource.isBuiltin() && CHESTS_OMINOUS_VAULT_RARE.equals(lootTableResourceKey.method_29177())) {
            builder.modifyPools(poolBuilder -> {
              poolBuilder.method_351(class_77.method_411(class_1802.field_8529)
                      .method_437(3)
                      .method_438(new class_109.class_4954().method_25992(
                              enchantmentRegistryLookup.method_46747(ShieldsEnchantmentKeys.LAUNCHING)
                      )));
            });
        }
    }
    //?} else {

    /*public static void modifyLootTables(ResourceKey<LootTable> lootTableResourceKey, LootTable lootTable, HolderLookup.Provider provider) {
        var enchantmentRegistryLookup = provider.lookupOrThrow(Registries.ENCHANTMENT);

        if (CHESTS_WOODLAND_MANSION.equals(lootTableResourceKey.location())) {
            lootTable.addPool(LootPool.lootPool().add(LootItem.lootTableItem(Items.BOOK)
                        .setWeight(6)
                        .apply(new EnchantRandomlyFunction.Builder().withEnchantment(
                                enchantmentRegistryLookup.getOrThrow(ShieldsEnchantmentKeys.EVOKERING)
                        ))).build()
            );
        }

        if (CHESTS_NETHER_BRIDGE.equals(lootTableResourceKey.location())) {
            lootTable.addPool(LootPool.lootPool().add(LootItem.lootTableItem(Items.BOOK)
                    .setWeight(5)
                    .apply(new EnchantRandomlyFunction.Builder().withEnchantment(
                            enchantmentRegistryLookup.getOrThrow(ShieldsEnchantmentKeys.LIFEBOUND)
                    ))).build()
            );
        }

        if (CHESTS_OMINOUS_VAULT_RARE.equals(lootTableResourceKey.location())) {
            lootTable.addPool(LootPool.lootPool().add(LootItem.lootTableItem(Items.BOOK)
                    .setWeight(3)
                    .apply(new EnchantRandomlyFunction.Builder().withEnchantment(
                            enchantmentRegistryLookup.getOrThrow(ShieldsEnchantmentKeys.LAUNCHING)
                    ))).build()
            );
        }
    }
    *///?}
}