package dev.imb11.shields.enchantments;

import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import net.minecraft.class_8111;

public class ShieldsEnchantmentEffects {
    public static void eventShieldBlock(class_3218 serverLevel, class_1309 livingEntity, class_1282 damageSource, float v, class_1268 interactionHand, class_1799 shield) {
        if (shield.method_7942()) {
            var enchantmentRegistry = livingEntity.method_37908().method_30349().method_66874(class_7924.field_41265).comp_349();

            // Check for our enchantments.
            int evokeringLevel = class_1890.method_8225(enchantmentRegistry.method_46747(ShieldsEnchantmentKeys.EVOKERING), shield);
            if (evokeringLevel > 0 && damageSource.method_5529() instanceof class_1309 attackerEntity) {
                Handlers.handleEvokering((class_3218) livingEntity.method_37908(), evokeringLevel, attackerEntity, livingEntity);
            }

            int lifeboundLevel = class_1890.method_8225(enchantmentRegistry.method_46747(ShieldsEnchantmentKeys.LIFEBOUND), shield);
            if (lifeboundLevel > 0 && damageSource.method_5529() instanceof class_1309 attackerEntity) {
                Handlers.handleLifebound(lifeboundLevel, (class_1657) livingEntity, attackerEntity);
            }
        }
    }

    public static void eventShieldDisabled(class_3218 serverLevel, class_1309 attacker, class_1309 defender, boolean defenderIsPlayer, class_1268 interactionHand, class_1799 shield, float v) {
        if (shield.method_7942()) {
            var enchantmentRegistry = defender.method_37908().method_30349().method_66874(class_7924.field_41265).comp_349();

            int launchingLevel = class_1890.method_8225(enchantmentRegistry.method_46747(ShieldsEnchantmentKeys.LAUNCHING), shield);
            if (launchingLevel > 0) {
                Handlers.handleLaunching(launchingLevel, attacker, shield);
            }

            int momentumLevel = class_1890.method_8225(enchantmentRegistry.method_46747(ShieldsEnchantmentKeys.MOMENTUM), shield);
            if (momentumLevel > 0) {
                Handlers.handleMomentum(momentumLevel, attacker, shield);
            }
        }
    }

    public static class Handlers {
        public static void handleLifebound(int enchantmentLevel, class_1657 player, class_1309 attacker) {
            // 1/4 chance, chance increases by 5% with each level
            int chance = 25 + (5 * enchantmentLevel);
            if (player.method_37908().field_9229.method_43048(100) >= chance) {
                return;
            }

            // 0.75 heart at lvl 1
            // 1.25 hearts at lvl 2
            float damage = 0.75f + (0.5f * (enchantmentLevel - 1));
            player.method_6025(damage);

            var registryLookup = player.method_37908().method_30349();
            var magicDamageSouce = new class_1282(registryLookup.method_66874(class_7924.field_42534).comp_349().method_46747(class_8111.field_42349));
            attacker.method_66277(player, 100);
            attacker.method_64419(magicDamageSouce, damage);
        }

        public static void handleLaunching(int enchantmentLevel, class_1309 player, class_1799 shield) {
            // 20% chance of launching to actually happen, regardless of level
            if (player.method_37908().field_9229.method_43048(100) >= 20) {
                return;
            }

            for (int i = 0; i < enchantmentLevel + 1; i++) {
                int radius = 2;

                if (enchantmentLevel == 1) {
                    radius = 4;
                } else {
                    radius = 2 + (enchantmentLevel - 1);
                }

                // Give all players around player resistance for 0.1s at 255 strength.
                player.method_37908().method_8333(player, player.method_5829().method_1014(radius), entity -> entity instanceof class_1657).forEach(entity -> {
                    ((class_1657) entity).method_6092(new class_1293(class_1294.field_5907, 2, 255));
                    // Move them up into the air slightly as well so they get launched further.
                    entity.method_5784(class_1313.field_6308, new class_243(0, 0.5, 0));
                });

                player.method_37908().method_8437(player, player.method_23317(), player.method_23318() + 0.5f, player.method_23321(), 2, class_1937.class_7867.field_40888);
            }

            // Damage the shield by 5 durability for each level
            shield.method_7970(5 * enchantmentLevel, player, player.method_32326(shield));
        }

        public static void handleEvokering(class_3218 serverLevel, int enchantmentLevel, class_1309 attacker, class_1309 defender) {
            // 1/4 chance, chance increases by 5% with each level
            int chance = 25 + (5 * enchantmentLevel);
            if (serverLevel.field_9229.method_43048(100) >= chance) {
                return;
            }

            class_1669 evokerFangs = new class_1669(serverLevel, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), 0, -6, defender);
            serverLevel.method_8649(evokerFangs);
        }

        public static void handleMomentum(int momentumLevel, class_1309 player, class_1799 shield) {
            // Give the player a speed III boost for 3 seconds. Each level adds 0.4s to the duration.
            player.method_6092(new class_1293(class_1294.field_5904, 60 + (8 * momentumLevel), 3, true, false));

            // Damage the shield by 1 durability for each level
            shield.method_7970(momentumLevel, player, player.method_32326(shield));
        }
    }
}
