package dev.imb11.shields.items;

import dev.imb11.shields.Platform;
import dev.imb11.shields.Shields;
import dev.imb11.shields.client.ShieldsClient;
import dev.imb11.shields.enchantments.ShieldsEnchantmentKeys;
import dev.imb11.shields.items.custom.ShieldPatchKitItem;
//? fabric {
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10707;
import net.minecraft.class_1304;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.ApiStatus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;

public class ShieldsItems {
    @ApiStatus.Internal
    public static final ArrayList<BannerShieldItemWrapper> SHIELD_ITEMS = new ArrayList<>();
    @ApiStatus.Internal
    public static final ArrayList<class_1792> SHIELD_PLATING_ITEMS = new ArrayList<>();

    public static final BannerShieldItemWrapper PLATED_SHIELD;
    public static final BannerShieldItemWrapper DIAMOND_SHIELD;
    public static final BannerShieldItemWrapper PLATED_DIAMOND_SHIELD;
    public static final BannerShieldItemWrapper COPPER_SHIELD;
    public static final BannerShieldItemWrapper PLATED_COPPER_SHIELD;
    public static final BannerShieldItemWrapper GOLD_SHIELD;
    public static final BannerShieldItemWrapper PLATED_GOLD_SHIELD;
    public static final BannerShieldItemWrapper NETHERITE_SHIELD;
    public static final BannerShieldItemWrapper PLATED_NETHERITE_SHIELD;
    public static final class_1792 SHIELD_PLATING;
    public static final class_1792 GOLD_SHIELD_PLATING;
    public static final class_1792 DIAMOND_SHIELD_PLATING;
    public static final class_1792 NETHERITE_SHIELD_PLATING;
    public static final class_1792 COPPER_SHIELD_PLATING;
    public static final class_1792 SHIELD_REPAIR_KIT;

    public static final class_5321<class_1761> CUSTOM_ITEM_GROUP_KEY;
    public static final class_1761 CUSTOM_ITEM_GROUP;

    /**
     * @apiNote This map is used to determine the output of the anvil when upgrading a shield with plating.
     * @usage Key: Plating, Value: [Input Shield, Output Shield]
     */
    @ApiStatus.Experimental
    public static final Map<class_1792, class_1792[]> PLATING_UPGRADE_MAP;

    static {
        PLATED_SHIELD = create("plated_shield", 420, 6 * 20, class_3489.field_15537);
        DIAMOND_SHIELD = create("diamond_shield", 867, 4 * 20, class_1802.field_8477);
        PLATED_DIAMOND_SHIELD = create("plated_diamond_shield", 1083, 5 * 20, class_1802.field_8477);
        GOLD_SHIELD = create("gold_shield", 451, 3 * 20, class_1802.field_8695);
        PLATED_GOLD_SHIELD = create("plated_gold_shield", 563, 4 * 20, class_1802.field_8695);
        NETHERITE_SHIELD = create("netherite_shield", 910, 5 * 20, class_1802.field_22020);
        PLATED_NETHERITE_SHIELD = create("plated_netherite_shield", 1137, 6 * 20, class_1802.field_22020);
        COPPER_SHIELD = create("copper_shield", 240, 8 * 20, class_1802.field_27022);
        PLATED_COPPER_SHIELD = create("plated_copper_shield", 300, 10 * 20, class_1802.field_27022);

        SHIELD_PLATING = register("shield_plating", class_1792::new);
        GOLD_SHIELD_PLATING = register("gold_shield_plating", class_1792::new);
        DIAMOND_SHIELD_PLATING = register("diamond_shield_plating", class_1792::new);
        NETHERITE_SHIELD_PLATING = register("netherite_shield_plating", class_1792::new);
        COPPER_SHIELD_PLATING = register("copper_shield_plating", class_1792::new);

        SHIELD_REPAIR_KIT = register("shield_repair_kit", (properties) -> new ShieldPatchKitItem(properties.method_7895(4)));

        SHIELD_PLATING_ITEMS.addAll(
                List.of(
                        SHIELD_PLATING,
                        GOLD_SHIELD_PLATING,
                        DIAMOND_SHIELD_PLATING,
                        NETHERITE_SHIELD_PLATING,
                        COPPER_SHIELD_PLATING
                )
        );

        SHIELD_ITEMS.addAll(
                List.of(
                        PLATED_SHIELD,
                        DIAMOND_SHIELD,
                        PLATED_DIAMOND_SHIELD,
                        GOLD_SHIELD,
                        PLATED_GOLD_SHIELD,
                        NETHERITE_SHIELD,
                        PLATED_NETHERITE_SHIELD,
                        COPPER_SHIELD,
                        PLATED_COPPER_SHIELD
                )
        );

        CUSTOM_ITEM_GROUP_KEY = class_5321.method_29179(class_7923.field_44687.method_46765(), class_2960.method_60655(Shields.MOD_ID, "item_group"));

        CUSTOM_ITEM_GROUP =
                //? fabric {
                FabricItemGroup.builder()
                //?} else {
                /*CreativeModeTab.builder()
                *///?}
                .method_47320(() -> new class_1799(GOLD_SHIELD))
                .method_47321(class_2561.method_43471("itemGroup.shields.shield_group"))
                .method_47317((itemDisplayParameters, output) -> {
                    var enchantmentStacks = new ArrayList<class_1799>();
                    itemDisplayParameters.comp_1253().method_46759(class_7924.field_41265).ifPresent(enchantments -> {
                        for (class_5321<class_1887> registeredEnchantment : ShieldsEnchantmentKeys.REGISTERED_ENCHANTMENTS) {
                            var reference = enchantments.method_46747(registeredEnchantment);
                            IntStream.rangeClosed(
                                    reference.comp_349().method_8187(),
                                    reference.comp_349().method_8183()
                            ).mapToObj(level ->
                                    class_1890.method_61711(new class_1889(reference, level))
                            ).forEach(enchantmentStacks::add);
                        }
                    });

                    // Output in rows of material.
                    // Fill gap with enchantments.
                    output.method_45421(class_1802.field_8255);
                    output.method_45421(SHIELD_PLATING);
                    output.method_45421(PLATED_SHIELD);
                    output.method_45421(COPPER_SHIELD);
                    output.method_45421(COPPER_SHIELD_PLATING);
                    output.method_45421(PLATED_COPPER_SHIELD);
                    output.method_45421(GOLD_SHIELD);
                    output.method_45421(GOLD_SHIELD_PLATING);
                    output.method_45421(PLATED_GOLD_SHIELD);

                    output.method_45421(DIAMOND_SHIELD);
                    output.method_45421(DIAMOND_SHIELD_PLATING);
                    output.method_45421(PLATED_DIAMOND_SHIELD);
                    output.method_45421(NETHERITE_SHIELD);
                    output.method_45421(NETHERITE_SHIELD_PLATING);
                    output.method_45421(PLATED_NETHERITE_SHIELD);
                    output.method_45421(SHIELD_REPAIR_KIT);

                    enchantmentStacks.forEach(output::method_45420);
                })
                .method_47324();

        PLATING_UPGRADE_MAP = Map.of(
                SHIELD_PLATING, new class_1792[]{class_1802.field_8255, PLATED_SHIELD},
                GOLD_SHIELD_PLATING, new class_1792[]{GOLD_SHIELD, PLATED_GOLD_SHIELD},
                DIAMOND_SHIELD_PLATING, new class_1792[]{DIAMOND_SHIELD, PLATED_DIAMOND_SHIELD},
                NETHERITE_SHIELD_PLATING, new class_1792[]{NETHERITE_SHIELD, PLATED_NETHERITE_SHIELD},
                COPPER_SHIELD_PLATING, new class_1792[]{COPPER_SHIELD, PLATED_COPPER_SHIELD}
        );
    }

    public static void initialize() {
        Shields.LOGGER.info("Initializing ShieldItems");

        class_2378.method_39197(class_7923.field_44687, CUSTOM_ITEM_GROUP_KEY, CUSTOM_ITEM_GROUP);
    }

    private static BannerShieldItemWrapper create(String id, int durability, int blockingDelay, class_1792 repairItems) {
        var item = register(id, (settings) -> new BannerShieldItemWrapper(settings
                .method_57349(class_9334.field_49619, class_9307.field_49404)
                .method_61649(9)
                .method_61648(repairItems)
                .method_64194(class_1304.field_6171)
                .method_57349(class_9334.field_56396, new class_10707(0.25F, 1.0F, List.of(new class_10707.class_10708(90.0F, Optional.empty(), 0.0F, 1.0F)), new class_10707.class_10709(3.0F, 1.0F, 1.0F), Optional.of(class_8103.field_56242), Optional.of(class_3417.field_15150), Optional.of(class_3417.field_15239)))
                .method_57349(class_9334.field_56399, class_3417.field_15239).method_7895(durability)
                .method_7895(durability)
                .method_63686(class_5321.method_29179(class_7924.field_41197, class_2960.method_60655("shields", id))), blockingDelay, 9, repairItems));

        if (Platform.isClient()) {
            ShieldsClient.registerDynamicShield(id);
        }

        return item;
    }

    private static BannerShieldItemWrapper create(String id, int durability, int blockingDelay, class_6862<class_1792> repairItems) {

        var item = register(id, (settings) -> new BannerShieldItemWrapper(settings
                .method_57349(class_9334.field_49619, class_9307.field_49404)
                .method_61649(9)
                .method_61647(repairItems)
                .method_64194(class_1304.field_6171)
                .method_57349(class_9334.field_56396, new class_10707(0.25F, 1.0F, List.of(new class_10707.class_10708(90.0F, Optional.empty(), 0.0F, 1.0F)), new class_10707.class_10709(3.0F, 1.0F, 1.0F), Optional.of(class_8103.field_56242), Optional.of(class_3417.field_15150), Optional.of(class_3417.field_15239)))
                .method_57349(class_9334.field_56399, class_3417.field_15239).method_7895(durability)
                .method_63686(class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(Shields.MOD_ID, id))), blockingDelay, 9, repairItems));

        if (Platform.isClient()) {
            ShieldsClient.registerDynamicShield(id);
        }

        return item;
    }

    private static <T extends class_1792> T register(String id, Function<class_1792.class_1793, T> builder) {
        class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(Shields.MOD_ID, id));

        return class_2378.method_39197(class_7923.field_41178, key, builder.apply(new class_1792.class_1793().method_63686(key)));
    }
}
