package dev.imb11.shields.items.custom;

import dev.imb11.shields.items.ShieldsItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_9334;

public class ShieldPatchKitItem extends class_1792 {
    public boolean mixin$did_flip_priorities = false;

    public ShieldPatchKitItem(class_1793 properties) {
        super(properties);
    }

    public class_1799 getResultHolderStack(class_1657 player, class_1268 hand) {
        if (mixin$did_flip_priorities) {
            mixin$did_flip_priorities = false;
            class_1268 oppositeHand = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            return player.method_5998(oppositeHand);
        } else {
            return player.method_5998(hand);
        }
    }

    @Override
    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 repairKitStack = player.method_5998(usedHand);
        if (!(level instanceof class_3218)) {
            return class_1269.field_5811;
        }

        class_1799 shieldStack = canUse(player, usedHand);

        if (shieldStack != null) {
            // If the shield is already at max damage, don't use the item.
            if (shieldStack.method_7936() == shieldStack.method_7919()) {
                return class_1269.field_5811;
            }

            // 1 minute between uses.
            player.method_7357().method_62835(repairKitStack, 20 * 60);
            shieldStack.method_57379(class_9334.field_50072, (int) Math.floor(shieldStack.method_7936() - 0.25 * shieldStack.method_7936()));

            // Repair to max durability.
            shieldStack.method_7974(0);

            // Damage the patch kit by 1 durability.
            repairKitStack.method_7970(1, player, player.method_32326(repairKitStack));

            player.method_5783(class_3417.field_15096, 1.0F, 1.0F);

            return class_1269.field_5812.method_61393(getResultHolderStack(player, usedHand));
        }

        return class_1269.field_5811;
    }

    private static class_1799 canUse(class_1657 player, class_1268 usedHand) {
        if (usedHand == class_1268.field_5808) {
            // Check if shield is in off-hand, and whether shield is more than 25% damaged.
            class_1799 offhandStack = player.method_6079();
            if (offhandStack.method_31573(ShieldsItemTags.CONVENTIONAL_SHIELDS)) {
                if (offhandStack.method_7919() > 0.25 * offhandStack.method_7936()) {
                    return offhandStack;
                }
            }
        } else {
            // Check if shield is in main-hand, and whether shield is more than 25% damaged.
            class_1799 mainhandStack = player.method_6047();
            if (mainhandStack.method_31573(ShieldsItemTags.CONVENTIONAL_SHIELDS)) {
                if (mainhandStack.method_7919() > 0.25 * mainhandStack.method_7936()) {
                    return mainhandStack;
                }
            }
        }
        return null;
    }
}
