package dev.imb11.shields.mixin;

import dev.imb11.shields.items.ShieldsItems;
//? fabric {
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_8047;
import net.minecraft.world.inventory.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;

@Mixin(class_1706.class)
public abstract class AnvilMenuMixin extends class_4861 {
    @Shadow
    @Final
    private class_3915 cost;

    @Shadow @Nullable private String itemName;

    public AnvilMenuMixin(@Nullable class_3917<?> menuType, int containerId, class_1661 inventory, class_3914 access, class_8047 slotDefinition) {
        super(menuType, containerId, inventory, access, slotDefinition);
    }
    //? fabric {
    

    /**
     * Credits to <a href="https://github.com/hiisuuii/infinicore/blob/master/src%2Fmain%2Fjava%2Fhisui%2Finfinicore%2Fmixin%2FInfinicoreMixin.java#L27">Infinicore's Implementation of Anvil Recipes</a>
     * for the correct mixin target.
     */
    @Inject(method = "createResult", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;isDamageableItem()Z", ordinal = 0), cancellable = true)
    private void inject(CallbackInfo info) {
        // [plating (input2)], [input1, output]
        var recipeMap = ShieldsItems.PLATING_UPGRADE_MAP;

        class_1799 expectedInput1 = this.field_22480.method_5438(0);
        class_1799 expectedPlating = this.field_22480.method_5438(1);

        for (Map.Entry<class_1792, class_1792[]> itemEntry : recipeMap.entrySet()) {
            var plating = itemEntry.getKey();
            var input1 = itemEntry.getValue()[0];
            var output = itemEntry.getValue()[1];

            // Check if the input items are the same as the expected items
            if (expectedInput1.method_7909() == input1 && expectedPlating.method_7909() == plating) {
                this.field_22479.method_5447(0, expectedInput1.method_60503(output));
                this.itemName = expectedInput1.method_7964().getString();
                this.cost.method_17404(1);
                info.cancel();
                return;
            }
        }
    }
    //?}
}
