package dev.imb11.shields.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.imb11.shields.enchantments.ShieldsEnchantmentKeys;
import net.minecraft.class_10707;
import net.minecraft.class_1309;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_10707.class)
public class BlocksAttacksMixin {

    @WrapOperation(method = "disable", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemCooldowns;addCooldown(Lnet/minecraft/world/item/ItemStack;I)V"))
    public void hurt(class_1796 instance, class_1799 stack, int original, Operation<Void> operation, @Local class_3218 level, @Local class_1309 entity) {
        var enchantmentLookup = level.method_30349().method_30530(class_7924.field_41265);
        // Check for bracing enchantment, each level decreases cooldown ticks by 10%.
        if (stack != null) {
            var enchantment = enchantmentLookup.method_46747(ShieldsEnchantmentKeys.BRACING);
            int enchantmentLevel = stack.method_58657().method_57536(enchantment);

            if (enchantmentLevel > 0) {
                int i = (int) (original * (1 - (0.1 * enchantmentLevel)));
                operation.call(instance, stack, i);
            }
        }

        operation.call(instance, stack, original);
    }
}
