package dev.imb11.shields.mixin;

import dev.imb11.shields.items.ShieldsItemTags;
import dev.imb11.shields.items.custom.ShieldPatchKitItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
    @Shadow public abstract class_1792 getItem();

    @Shadow public abstract boolean is(class_6862<class_1792> tag);

    @Inject(method = "use", at = @At("HEAD"), cancellable = true)
    public void prioritizeShieldRepairKit(class_1937 level, class_1657 player, class_1268 usedHand, CallbackInfoReturnable<class_1269> cir) {
        if (this.is(ShieldsItemTags.SHIELDS)) {
            // Check if alternate hand has a Shield Repair Kit
            class_1268 opposite = usedHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            class_1799 oppositeStack = player.method_5998(opposite);

            if (oppositeStack.method_7909() instanceof ShieldPatchKitItem kitItem) {
                // Swap hands
                kitItem.mixin$did_flip_priorities = true;
                cir.setReturnValue(kitItem.method_7836(level, player, opposite));
            }
        }
    }
}
