package dev.imb11.shields.mixin;

import dev.imb11.shields.items.ShieldsItemTags;
import net.minecraft.class_1746;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1872;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;


@Mixin(class_1872.class)
public abstract class ShieldDecorationRecipeMixin extends class_1852 {


    public ShieldDecorationRecipeMixin(class_7710 category) {
        super(category);
    }

    /**
     * Credits to <a href="https://github.com/pnk2u/More-Shield-Variants/blob/1.21.5(-8)/src/main/java/de/pnku/lolmsv/mixin/recipe/ShieldDecorationRecipeMixin.java">More Shield Variant's Implementation of Shield Rendering</a>
     * for the correct mixin target.
     */
    @Inject(method = "matches(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/world/level/Level;)Z", at = @At("HEAD"), cancellable = true)
    private void injectedMatches(class_9694 craftingInput, class_1937 level, CallbackInfoReturnable<Boolean> cir) {
        class_1799 itemStack = class_1799.field_8037;
        class_1799 itemStack2 = class_1799.field_8037;
        for (int i = 0; i < craftingInput.method_59983(); ++i) {
            class_1799 itemStack3 = craftingInput.method_59984(i);
            if (itemStack3.method_7960()) continue;
            if (itemStack3.method_7909() instanceof class_1746) {
                if (!itemStack2.method_7960()) {
                    cir.setReturnValue(false);
                }
                itemStack2 = itemStack3;
                continue;
            }
            if (itemStack3.method_31573(ShieldsItemTags.SHIELDS)) {
                if (!itemStack.method_7960()) {
                    cir.setReturnValue(false);
                }
                class_9307 bannerPatternsComponent = itemStack3.method_58695(class_9334.field_49619, class_9307.field_49404);
                if (!bannerPatternsComponent.comp_2428().isEmpty()) {
                    cir.setReturnValue(false);
                }
                itemStack = itemStack3;
                continue;
            }
            cir.setReturnValue(false);
        }
        cir.setReturnValue(!itemStack.method_7960() && !itemStack2.method_7960());
    }

    @Inject(method = "assemble(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", at = @At("HEAD"), cancellable = true)
    private void injectedAssemble(class_9694 craftingInput, class_7225.class_7874 provider, CallbackInfoReturnable<class_1799> cir) {
        class_1799 itemStack = class_1799.field_8037;
        class_1799 itemStack2 = class_1799.field_8037;
        for (int i = 0; i < craftingInput.method_59983(); ++i) {
            class_1799 itemStack3 = craftingInput.method_59984(i);
            if (itemStack3.method_7960()) continue;
            if (itemStack3.method_7909() instanceof class_1746) {
                itemStack = itemStack3;
                continue;
            }
            if (!(itemStack3.method_31573(ShieldsItemTags.SHIELDS))) continue;
            itemStack2 = itemStack3.method_7972();
        }
        if (itemStack2.method_7960()) {
            cir.setReturnValue(itemStack2);
        }
        itemStack2.method_57379(class_9334.field_49619, itemStack.method_58694(class_9334.field_49619));
        itemStack2.method_57379(class_9334.field_49620, ((class_1746)itemStack.method_7909()).method_7706());
        cir.setReturnValue(itemStack2);
    }

}