package dev.imb11.shields.mixin;

import java.util.Objects;
import dev.imb11.shields.client.ShieldsClient;
import net.minecraft.class_10509;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4013;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_600;
import net.minecraft.class_811;
import net.minecraft.class_823;
import net.minecraft.class_918;
import net.minecraft.class_9307;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.world.item.*;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_10509.class)
public abstract class ShieldSpecialRendererMixin implements class_4013 {


    @Shadow
    @Final
    private class_600 model;

    /**
     * Credits to <a href="https://github.com/pnk2u/More-Shield-Variants/blob/1.21.5(-8)/src/client/java/de/pnku/lolmsv/mixin/client/ShieldSpecialRendererMixin.java">More Shield Variant's Implementation of Shield Rendering</a>
     * for the correct mixin target.
     */
    @Inject(method = "render(Lnet/minecraft/core/component/DataComponentMap;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIZ)V", at = @At("TAIL"))
    private void injectedRender(class_9323 dataComponentMap, class_811 displayContext, class_4587 poseStack, class_4597 source, int light, int overlay, boolean hasFoil, CallbackInfo ci) {
        class_2561 itemNameComponent = dataComponentMap.method_58694(class_9334.field_50239);
        if (itemNameComponent.method_10851() instanceof class_2588 translatableContents) {
            var key = translatableContents.method_11022();
            if (key.contains("item.shields")) {
                var material = translatableContents.method_11022().replace("item.shields.", "");
                class_9307 bannerPatternsComponent = dataComponentMap.method_58695(class_9334.field_49619, class_9307.field_49404);
                class_1767 shieldBannerDyeColor = dataComponentMap.method_58694(class_9334.field_49620);
                boolean hasBanner = !bannerPatternsComponent.comp_2428().isEmpty() || shieldBannerDyeColor != null;
                poseStack.method_22903();
                poseStack.method_22905(1.0f, -1.0f, -1.0f);

                var materials = ShieldsClient.REGISTERED_MATERIALS.get(material);
                class_4730 shieldBaseTextureLocation = materials.get(0);
                class_4730 noPatternShieldBaseTextureLocation = materials.get(1);
                class_4730 spriteIdentifier = hasBanner ? shieldBaseTextureLocation : noPatternShieldBaseTextureLocation;
                class_4588 vertexConsumer = spriteIdentifier.method_24148().method_24108(class_918.method_23181(source, this.model.method_23500(spriteIdentifier.method_24144()), displayContext == class_811.field_4317, hasFoil));
                this.model.method_23775().method_22698(poseStack, vertexConsumer, light, overlay);
                if (hasBanner) {
                    class_823.method_23802(poseStack, source, light, overlay, this.model.method_23774(), spriteIdentifier, false, Objects.requireNonNullElse(shieldBannerDyeColor, class_1767.field_7952), bannerPatternsComponent, hasFoil, false);
                }
                else {
                    this.model.method_23774().method_22698(poseStack, vertexConsumer, light, overlay);
                }
                poseStack.method_22909();
            }
        }
    }
}