/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.shields.enchantments;

import dev.imb11.shields.enchantments.ShieldsEnchantmentKeys;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class ShieldEnchantmentLootHelper {
    private static final ResourceLocation CHESTS_NETHER_BRIDGE = ResourceLocation.parse((String)"chests/nether_bridge");
    private static final ResourceLocation CHESTS_WOODLAND_MANSION = ResourceLocation.parse((String)"chests/woodland_mansion");
    private static final ResourceLocation CHESTS_OMINOUS_VAULT_RARE = ResourceLocation.parse((String)"chests/trial_chambers/reward_ominous_rare");

    public static void modifyLootTables(ResourceKey<LootTable> lootTableResourceKey, LootTable lootTable, HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup enchantmentRegistryLookup = provider.lookupOrThrow(Registries.ENCHANTMENT);
        if (CHESTS_WOODLAND_MANSION.equals((Object)lootTableResourceKey.location())) {
            lootTable.addPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).setWeight(6).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)enchantmentRegistryLookup.getOrThrow(ShieldsEnchantmentKeys.EVOKERING)))).build());
        }
        if (CHESTS_NETHER_BRIDGE.equals((Object)lootTableResourceKey.location())) {
            lootTable.addPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).setWeight(5).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)enchantmentRegistryLookup.getOrThrow(ShieldsEnchantmentKeys.LIFEBOUND)))).build());
        }
        if (CHESTS_OMINOUS_VAULT_RARE.equals((Object)lootTableResourceKey.location())) {
            lootTable.addPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).setWeight(3).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)enchantmentRegistryLookup.getOrThrow(ShieldsEnchantmentKeys.LAUNCHING)))).build());
        }
    }
}

