/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.shields.enchantments;

import dev.imb11.shields.enchantments.ShieldsEnchantmentKeys;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShieldsEnchantmentEffects {
    public static void eventShieldBlock(ServerLevel serverLevel, LivingEntity livingEntity, DamageSource damageSource, float v, InteractionHand interactionHand, ItemStack shield) {
        if (shield.isEnchanted()) {
            Entity entity;
            int lifeboundLevel;
            Entity entity2;
            Registry enchantmentRegistry = (Registry)livingEntity.level().registryAccess().getOrThrow(Registries.ENCHANTMENT).value();
            int evokeringLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentRegistry.getOrThrow(ShieldsEnchantmentKeys.EVOKERING), (ItemStack)shield);
            if (evokeringLevel > 0 && (entity2 = damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity attackerEntity = (LivingEntity)entity2;
                Handlers.handleEvokering((ServerLevel)livingEntity.level(), evokeringLevel, attackerEntity, livingEntity);
            }
            if ((lifeboundLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentRegistry.getOrThrow(ShieldsEnchantmentKeys.LIFEBOUND), (ItemStack)shield)) > 0 && (entity = damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity attackerEntity = (LivingEntity)entity;
                Handlers.handleLifebound(lifeboundLevel, (Player)livingEntity, attackerEntity);
            }
        }
    }

    public static void eventShieldDisabled(ServerLevel serverLevel, LivingEntity attacker, LivingEntity defender, boolean defenderIsPlayer, InteractionHand interactionHand, ItemStack shield, float v) {
        if (shield.isEnchanted()) {
            int momentumLevel;
            Registry enchantmentRegistry = (Registry)defender.level().registryAccess().getOrThrow(Registries.ENCHANTMENT).value();
            int launchingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentRegistry.getOrThrow(ShieldsEnchantmentKeys.LAUNCHING), (ItemStack)shield);
            if (launchingLevel > 0) {
                Handlers.handleLaunching(launchingLevel, attacker, shield);
            }
            if ((momentumLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentRegistry.getOrThrow(ShieldsEnchantmentKeys.MOMENTUM), (ItemStack)shield)) > 0) {
                Handlers.handleMomentum(momentumLevel, attacker, shield);
            }
        }
    }

    public static class Handlers {
        public static void handleLifebound(int enchantmentLevel, Player player, LivingEntity attacker) {
            int chance = 25 + 5 * enchantmentLevel;
            if (player.level().random.nextInt(100) >= chance) {
                return;
            }
            float damage = 0.75f + 0.5f * (float)(enchantmentLevel - 1);
            player.heal(damage);
            RegistryAccess registryLookup = player.level().registryAccess();
            DamageSource magicDamageSouce = new DamageSource((Holder)((Registry)registryLookup.getOrThrow(Registries.DAMAGE_TYPE).value()).getOrThrow(DamageTypes.MAGIC));
            attacker.setLastHurtByPlayer(player, 100);
            attacker.hurt(magicDamageSouce, damage);
        }

        public static void handleLaunching(int enchantmentLevel, LivingEntity player, ItemStack shield) {
            if (player.level().random.nextInt(100) >= 20) {
                return;
            }
            for (int i = 0; i < enchantmentLevel + 1; ++i) {
                int radius = 2;
                radius = enchantmentLevel == 1 ? 4 : 2 + (enchantmentLevel - 1);
                player.level().getEntities((Entity)player, player.getBoundingBox().inflate((double)radius), entity -> entity instanceof Player).forEach(entity -> {
                    ((Player)entity).addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 2, 255));
                    entity.move(MoverType.SELF, new Vec3(0.0, 0.5, 0.0));
                });
                player.level().explode((Entity)player, player.getX(), player.getY() + 0.5, player.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
            }
            shield.hurtAndBreak(5 * enchantmentLevel, player, player.getEquipmentSlotForItem(shield));
        }

        public static void handleEvokering(ServerLevel serverLevel, int enchantmentLevel, LivingEntity attacker, LivingEntity defender) {
            int chance = 25 + 5 * enchantmentLevel;
            if (serverLevel.random.nextInt(100) >= chance) {
                return;
            }
            EvokerFangs evokerFangs = new EvokerFangs((Level)serverLevel, attacker.getX(), attacker.getY(), attacker.getZ(), 0.0f, -6, defender);
            serverLevel.addFreshEntity((Entity)evokerFangs);
        }

        public static void handleMomentum(int momentumLevel, LivingEntity player, ItemStack shield) {
            player.addEffect(new MobEffectInstance(MobEffects.SPEED, 60 + 8 * momentumLevel, 3, true, false));
            shield.hurtAndBreak(momentumLevel, player, player.getEquipmentSlotForItem(shield));
        }
    }
}

