/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.shields.items;

import dev.imb11.shields.Platform;
import dev.imb11.shields.Shields;
import dev.imb11.shields.client.ShieldsClient;
import dev.imb11.shields.enchantments.ShieldsEnchantmentKeys;
import dev.imb11.shields.items.BannerShieldItemWrapper;
import dev.imb11.shields.items.custom.ShieldPatchKitItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.ApiStatus;

public class ShieldsItems {
    @ApiStatus.Internal
    public static final ArrayList<BannerShieldItemWrapper> SHIELD_ITEMS = new ArrayList();
    @ApiStatus.Internal
    public static final ArrayList<Item> SHIELD_PLATING_ITEMS = new ArrayList();
    public static final BannerShieldItemWrapper PLATED_SHIELD = ShieldsItems.create("plated_shield", 420, 120, (TagKey<Item>)ItemTags.PLANKS);
    public static final BannerShieldItemWrapper DIAMOND_SHIELD = ShieldsItems.create("diamond_shield", 867, 80, Items.DIAMOND);
    public static final BannerShieldItemWrapper PLATED_DIAMOND_SHIELD = ShieldsItems.create("plated_diamond_shield", 1083, 100, Items.DIAMOND);
    public static final BannerShieldItemWrapper COPPER_SHIELD;
    public static final BannerShieldItemWrapper PLATED_COPPER_SHIELD;
    public static final BannerShieldItemWrapper GOLD_SHIELD;
    public static final BannerShieldItemWrapper PLATED_GOLD_SHIELD;
    public static final BannerShieldItemWrapper NETHERITE_SHIELD;
    public static final BannerShieldItemWrapper PLATED_NETHERITE_SHIELD;
    public static final Item SHIELD_PLATING;
    public static final Item GOLD_SHIELD_PLATING;
    public static final Item DIAMOND_SHIELD_PLATING;
    public static final Item NETHERITE_SHIELD_PLATING;
    public static final Item COPPER_SHIELD_PLATING;
    public static final Item SHIELD_REPAIR_KIT;
    public static final ResourceKey<CreativeModeTab> CUSTOM_ITEM_GROUP_KEY;
    public static final CreativeModeTab CUSTOM_ITEM_GROUP;
    @ApiStatus.Experimental
    public static final Map<Item, Item[]> PLATING_UPGRADE_MAP;

    public static void initialize() {
        Shields.LOGGER.info("Initializing ShieldItems");
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, CUSTOM_ITEM_GROUP_KEY, (Object)CUSTOM_ITEM_GROUP);
    }

    private static BannerShieldItemWrapper create(String id, int durability, int blockingDelay, Item repairItems) {
        BannerShieldItemWrapper item = ShieldsItems.register(id, settings -> new BannerShieldItemWrapper(settings.component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY).enchantable(9).repairable(repairItems).equippableUnswappable(EquipmentSlot.OFFHAND).component(DataComponents.BLOCKS_ATTACKS, (Object)new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(90.0f, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK))).component(DataComponents.BREAK_SOUND, (Object)SoundEvents.SHIELD_BREAK).durability(durability).durability(durability).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shields", (String)id))), blockingDelay, 9, repairItems));
        if (Platform.isClient()) {
            ShieldsClient.registerDynamicShield(id);
        }
        return item;
    }

    private static BannerShieldItemWrapper create(String id, int durability, int blockingDelay, TagKey<Item> repairItems) {
        BannerShieldItemWrapper item = ShieldsItems.register(id, settings -> new BannerShieldItemWrapper(settings.component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY).enchantable(9).repairable(repairItems).equippableUnswappable(EquipmentSlot.OFFHAND).component(DataComponents.BLOCKS_ATTACKS, (Object)new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(90.0f, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK))).component(DataComponents.BREAK_SOUND, (Object)SoundEvents.SHIELD_BREAK).durability(durability).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shields", (String)id))), blockingDelay, 9, repairItems));
        if (Platform.isClient()) {
            ShieldsClient.registerDynamicShield(id);
        }
        return item;
    }

    private static <T extends Item> T register(String id, Function<Item.Properties, T> builder) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shields", (String)id));
        return (T)((Item)Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceKey)key, (Object)((Item)builder.apply(new Item.Properties().setId(key)))));
    }

    static {
        GOLD_SHIELD = ShieldsItems.create("gold_shield", 451, 60, Items.GOLD_INGOT);
        PLATED_GOLD_SHIELD = ShieldsItems.create("plated_gold_shield", 563, 80, Items.GOLD_INGOT);
        NETHERITE_SHIELD = ShieldsItems.create("netherite_shield", 910, 100, Items.NETHERITE_INGOT);
        PLATED_NETHERITE_SHIELD = ShieldsItems.create("plated_netherite_shield", 1137, 120, Items.NETHERITE_INGOT);
        COPPER_SHIELD = ShieldsItems.create("copper_shield", 240, 160, Items.COPPER_INGOT);
        PLATED_COPPER_SHIELD = ShieldsItems.create("plated_copper_shield", 300, 200, Items.COPPER_INGOT);
        SHIELD_PLATING = ShieldsItems.register("shield_plating", Item::new);
        GOLD_SHIELD_PLATING = ShieldsItems.register("gold_shield_plating", Item::new);
        DIAMOND_SHIELD_PLATING = ShieldsItems.register("diamond_shield_plating", Item::new);
        NETHERITE_SHIELD_PLATING = ShieldsItems.register("netherite_shield_plating", Item::new);
        COPPER_SHIELD_PLATING = ShieldsItems.register("copper_shield_plating", Item::new);
        SHIELD_REPAIR_KIT = ShieldsItems.register("shield_repair_kit", properties -> new ShieldPatchKitItem(properties.durability(4)));
        SHIELD_PLATING_ITEMS.addAll(List.of(SHIELD_PLATING, GOLD_SHIELD_PLATING, DIAMOND_SHIELD_PLATING, NETHERITE_SHIELD_PLATING, COPPER_SHIELD_PLATING));
        SHIELD_ITEMS.addAll(List.of(PLATED_SHIELD, DIAMOND_SHIELD, PLATED_DIAMOND_SHIELD, GOLD_SHIELD, PLATED_GOLD_SHIELD, NETHERITE_SHIELD, PLATED_NETHERITE_SHIELD, COPPER_SHIELD, PLATED_COPPER_SHIELD));
        CUSTOM_ITEM_GROUP_KEY = ResourceKey.create((ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shields", (String)"item_group"));
        CUSTOM_ITEM_GROUP = CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)GOLD_SHIELD)).title((Component)Component.translatable((String)"itemGroup.shields.shield_group")).displayItems((itemDisplayParameters, output) -> {
            ArrayList<ItemStack> enchantmentStacks = new ArrayList<ItemStack>();
            itemDisplayParameters.holders().lookup(Registries.ENCHANTMENT).ifPresent(enchantments -> {
                for (ResourceKey<Enchantment> registeredEnchantment : ShieldsEnchantmentKeys.REGISTERED_ENCHANTMENTS) {
                    Holder.Reference reference = enchantments.getOrThrow(registeredEnchantment);
                    IntStream.rangeClosed(((Enchantment)reference.value()).getMinLevel(), ((Enchantment)reference.value()).getMaxLevel()).mapToObj(level -> EnchantmentHelper.createBook((EnchantmentInstance)new EnchantmentInstance((Holder)reference, level))).forEach(enchantmentStacks::add);
                }
            });
            output.accept((ItemLike)Items.SHIELD);
            output.accept((ItemLike)SHIELD_PLATING);
            output.accept((ItemLike)PLATED_SHIELD);
            output.accept((ItemLike)COPPER_SHIELD);
            output.accept((ItemLike)COPPER_SHIELD_PLATING);
            output.accept((ItemLike)PLATED_COPPER_SHIELD);
            output.accept((ItemLike)GOLD_SHIELD);
            output.accept((ItemLike)GOLD_SHIELD_PLATING);
            output.accept((ItemLike)PLATED_GOLD_SHIELD);
            output.accept((ItemLike)DIAMOND_SHIELD);
            output.accept((ItemLike)DIAMOND_SHIELD_PLATING);
            output.accept((ItemLike)PLATED_DIAMOND_SHIELD);
            output.accept((ItemLike)NETHERITE_SHIELD);
            output.accept((ItemLike)NETHERITE_SHIELD_PLATING);
            output.accept((ItemLike)PLATED_NETHERITE_SHIELD);
            output.accept((ItemLike)SHIELD_REPAIR_KIT);
            enchantmentStacks.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        }).build();
        PLATING_UPGRADE_MAP = Map.of(SHIELD_PLATING, new Item[]{Items.SHIELD, PLATED_SHIELD}, GOLD_SHIELD_PLATING, new Item[]{GOLD_SHIELD, PLATED_GOLD_SHIELD}, DIAMOND_SHIELD_PLATING, new Item[]{DIAMOND_SHIELD, PLATED_DIAMOND_SHIELD}, NETHERITE_SHIELD_PLATING, new Item[]{NETHERITE_SHIELD, PLATED_NETHERITE_SHIELD}, COPPER_SHIELD_PLATING, new Item[]{COPPER_SHIELD, PLATED_COPPER_SHIELD});
    }
}

