/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.shields.items.custom;

import dev.imb11.shields.items.ShieldsItemTags;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ShieldPatchKitItem
extends Item {
    public boolean mixin$did_flip_priorities = false;

    public ShieldPatchKitItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getResultHolderStack(Player player, InteractionHand hand) {
        if (this.mixin$did_flip_priorities) {
            this.mixin$did_flip_priorities = false;
            InteractionHand oppositeHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            return player.getItemInHand(oppositeHand);
        }
        return player.getItemInHand(hand);
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack repairKitStack = player.getItemInHand(usedHand);
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ItemStack shieldStack = ShieldPatchKitItem.canUse(player, usedHand);
        if (shieldStack != null) {
            if (shieldStack.getMaxDamage() == shieldStack.getDamageValue()) {
                return InteractionResult.PASS;
            }
            player.getCooldowns().addCooldown(repairKitStack, 1200);
            shieldStack.set(DataComponents.MAX_DAMAGE, (Object)((int)Math.floor((double)shieldStack.getMaxDamage() - 0.25 * (double)shieldStack.getMaxDamage())));
            shieldStack.setDamageValue(0);
            repairKitStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(repairKitStack));
            player.playSound(SoundEvents.UI_LOOM_TAKE_RESULT, 1.0f, 1.0f);
            return InteractionResult.SUCCESS.heldItemTransformedTo(this.getResultHolderStack(player, usedHand));
        }
        return InteractionResult.PASS;
    }

    private static ItemStack canUse(Player player, InteractionHand usedHand) {
        if (usedHand == InteractionHand.MAIN_HAND) {
            ItemStack offhandStack = player.getOffhandItem();
            if (offhandStack.is(ShieldsItemTags.CONVENTIONAL_SHIELDS) && (double)offhandStack.getDamageValue() > 0.25 * (double)offhandStack.getMaxDamage()) {
                return offhandStack;
            }
        } else {
            ItemStack mainhandStack = player.getMainHandItem();
            if (mainhandStack.is(ShieldsItemTags.CONVENTIONAL_SHIELDS) && (double)mainhandStack.getDamageValue() > 0.25 * (double)mainhandStack.getMaxDamage()) {
                return mainhandStack;
            }
        }
        return null;
    }
}

