/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.shields.mixin;

import dev.imb11.shields.items.ShieldsItemTags;
import dev.imb11.shields.items.custom.ShieldPatchKitItem;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract Item getItem();

    @Shadow
    public abstract boolean is(TagKey<Item> var1);

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void prioritizeShieldRepairKit(Level level, Player player, InteractionHand usedHand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionHand opposite;
        ItemStack oppositeStack;
        Item item;
        if (this.is(ShieldsItemTags.SHIELDS) && (item = (oppositeStack = player.getItemInHand(opposite = usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)).getItem()) instanceof ShieldPatchKitItem) {
            ShieldPatchKitItem kitItem = (ShieldPatchKitItem)item;
            kitItem.mixin$did_flip_priorities = true;
            cir.setReturnValue((Object)kitItem.use(level, player, opposite));
        }
    }
}

