/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.shields.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.imb11.shields.client.ShieldsClient;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.ShieldSpecialRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShieldSpecialRenderer.class})
public abstract class ShieldSpecialRendererMixin
implements ResourceManagerReloadListener {
    @Shadow
    @Final
    private ShieldModel model;

    @Inject(method={"render(Lnet/minecraft/core/component/DataComponentMap;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIZ)V"}, at={@At(value="TAIL")})
    private void injectedRender(DataComponentMap dataComponentMap, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource source, int light, int overlay, boolean hasFoil, CallbackInfo ci) {
        TranslatableContents translatableContents;
        String key;
        Component itemNameComponent = (Component)dataComponentMap.get(DataComponents.ITEM_NAME);
        ComponentContents componentContents = itemNameComponent.getContents();
        if (componentContents instanceof TranslatableContents && (key = (translatableContents = (TranslatableContents)componentContents).getKey()).contains("item.shields")) {
            String material = translatableContents.getKey().replace("item.shields.", "");
            BannerPatternLayers bannerPatternsComponent = (BannerPatternLayers)dataComponentMap.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            DyeColor shieldBannerDyeColor = (DyeColor)dataComponentMap.get(DataComponents.BASE_COLOR);
            boolean hasBanner = !bannerPatternsComponent.layers().isEmpty() || shieldBannerDyeColor != null;
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            List<Material> materials = ShieldsClient.REGISTERED_MATERIALS.get(material);
            Material shieldBaseTextureLocation = materials.get(0);
            Material noPatternShieldBaseTextureLocation = materials.get(1);
            Material spriteIdentifier = hasBanner ? shieldBaseTextureLocation : noPatternShieldBaseTextureLocation;
            VertexConsumer vertexConsumer = spriteIdentifier.sprite().wrap(ItemRenderer.getFoilBuffer((MultiBufferSource)source, (RenderType)this.model.renderType(spriteIdentifier.atlasLocation()), (displayContext == ItemDisplayContext.GUI ? 1 : 0) != 0, (boolean)hasFoil));
            this.model.handle().render(poseStack, vertexConsumer, light, overlay);
            if (hasBanner) {
                BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)source, (int)light, (int)overlay, (ModelPart)this.model.plate(), (Material)spriteIdentifier, (boolean)false, (DyeColor)Objects.requireNonNullElse(shieldBannerDyeColor, DyeColor.WHITE), (BannerPatternLayers)bannerPatternsComponent, (boolean)hasFoil, (boolean)false);
            } else {
                this.model.plate().render(poseStack, vertexConsumer, light, overlay);
            }
            poseStack.popPose();
        }
    }
}

