/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.shields.neoforge;

import dev.imb11.shields.Shields;
import dev.imb11.shields.compat.eiv.EivCompat;
import dev.imb11.shields.enchantments.ShieldEnchantmentLootHelper;
import dev.imb11.shields.items.ShieldsItems;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="shields")
@EventBusSubscriber(modid="shields")
public class ShieldsNeoForge {
    public ShieldsNeoForge(IEventBus bus) {
        Shields.init();
    }

    @SubscribeEvent
    public static void registerItems(RegisterEvent registerEvent) {
        if (registerEvent.getRegistryKey().equals(Registries.ITEM)) {
            ShieldsItems.initialize();
        }
    }

    @SubscribeEvent
    public static void registerItems(FMLCommonSetupEvent registerEvent) {
        if (ModList.get().isLoaded("eiv")) {
            EivCompat.init();
        }
    }

    @SubscribeEvent
    public static void shieldAnvilRecipes(AnvilUpdateEvent anvilUpdateEvent) {
        Map<Item, Item[]> recipeMap = ShieldsItems.PLATING_UPGRADE_MAP;
        ItemStack expectedInput1 = anvilUpdateEvent.getLeft();
        ItemStack expectedPlating = anvilUpdateEvent.getRight();
        for (Map.Entry<Item, Item[]> itemEntry : recipeMap.entrySet()) {
            Item plating = itemEntry.getKey();
            Item input1 = itemEntry.getValue()[0];
            Item output = itemEntry.getValue()[1];
            if (expectedInput1.getItem() != input1 || expectedPlating.getItem() != plating) continue;
            anvilUpdateEvent.setOutput(expectedInput1.transmuteCopy((ItemLike)output));
            anvilUpdateEvent.setXpCost(1);
            return;
        }
    }

    @SubscribeEvent
    public static void loadLootModifiers(LootTableLoadEvent event) {
        ShieldEnchantmentLootHelper.modifyLootTables((ResourceKey<LootTable>)event.getKey(), event.getTable(), event.getRegistries());
    }
}

