package com.mikitellurium.telluriumforge.test;

import com.mikitellurium.telluriumforge.TelluriumForge;
import com.mikitellurium.telluriumforge.networking.packet.IntSyncPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkingTest {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel(TelluriumForge.modId());
    private static int id = 0;

    public static void register() {
        INSTANCE.registerMessage(SpawnPacket.handler(), SpawnPacket.class, id++, Side.SERVER);
        INSTANCE.registerMessage(handler(), IntSyncPacket.class, id++, Side.CLIENT);
    }

    public static class SpawnPacket implements IMessage {
        public static IMessageHandler<SpawnPacket, IMessage> handler() {
            return (message, context) -> {
                EntityPlayerMP player = context.getServerHandler().player;
                WorldServer world = player.getServerWorld();
                BlockPos pos = message.pos;
                world.addScheduledTask(() -> {
                    EntitySheep sheep = new EntitySheep(world);
                    sheep.setPosition(pos.getX(), pos.getY(), pos.getZ());
                    sheep.setFleeceColor(EnumDyeColor.LIGHT_BLUE);
                    world.spawnEntity(sheep);
                });

                return null;
            };
        }

        private BlockPos pos;

        public SpawnPacket() {}

        public SpawnPacket(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }

        @Override
        public void toBytes(ByteBuf buf) {
            buf.writeInt(pos.getX());
            buf.writeInt(pos.getY());
            buf.writeInt(pos.getZ());
        }
    }

    public static IMessageHandler<IntSyncPacket, IMessage> handler() {
        return new IMessageHandler<IntSyncPacket, IMessage>() {
            @Override
            public IMessage onMessage(IntSyncPacket message, MessageContext ctx) {
                EntityPlayerSP player = Minecraft.getMinecraft().player;
                player.sendMessage(new TextComponentString("Message received from " + message.getBlockPos()));
                return null;
            }
        };
    }
}
