package com.mikitellurium.telluriumforge.test;

import com.mikitellurium.telluriumforge.networking.packet.IntSyncPacket;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TestBlock extends Block {
    public TestBlock() {
        super(Material.ROCK, MapColor.STONE);
        this.setHardness(1.5F).setResistance(10.0F);
    }

    @Override
    public SoundType getSoundType() {
        return SoundType.STONE;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand,
                                    EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            if (worldIn.isRemote) {
                NetworkingTest.INSTANCE.sendToServer(new NetworkingTest.SpawnPacket(pos.up()));
            } else {
                NetworkingTest.INSTANCE.sendTo(new IntSyncPacket(pos, 0) {}, (EntityPlayerMP)playerIn);
            }
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }
}
