/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.energy;

import net.minecraftforge.energy.EnergyStorage;

public abstract class SimpleEnergyStorage
extends EnergyStorage {
    public SimpleEnergyStorage(int capacity) {
        super(capacity);
    }

    public SimpleEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public SimpleEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public SimpleEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int receivedEnergy = super.receiveEnergy(maxReceive, simulate);
        if (receivedEnergy != 0) {
            this.onEnergyChanged();
        }
        return receivedEnergy;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extractedEnergy = super.extractEnergy(maxExtract, simulate);
        if (extractedEnergy != 0) {
            this.onEnergyChanged();
        }
        return extractedEnergy;
    }

    public void setEnergy(int energy) {
        this.energy = Math.max(0, Math.min(energy, this.capacity));
    }

    public abstract void onEnergyChanged();
}

