/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public class EventHelper {
    private final List<EventRegistration> events = new ArrayList<EventRegistration>();

    public EventHelper registerClass(Class<?> clazz) {
        return this.registerClass(MinecraftForge.EVENT_BUS, clazz);
    }

    public EventHelper registerClass(EventBus eventBus, Class<?> clazz) {
        this.events.add(new EventRegistration(eventBus, clazz));
        return this;
    }

    public void registerAll() {
        this.events.forEach(EventRegistration::register);
        this.events.clear();
    }

    private static class EventRegistration {
        private final EventBus eventBus;
        private final Class<?> eventClass;

        private EventRegistration(EventBus eventBus, Class<?> eventClass) {
            this.eventBus = eventBus;
            this.eventClass = eventClass;
        }

        void register() {
            this.eventBus.register(this.eventClass);
        }
    }
}

