/*
 * Decompiled with CFR 0.152.
 */
package net.vi.mobhealthindicators.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.vi.mobhealthindicators.EntityTypeToEntity;
import net.vi.mobhealthindicators.commands.SpecificStringArgumentType;
import net.vi.mobhealthindicators.config.Config;
import net.vi.mobhealthindicators.config.screen.ConfigScreenHandler;

public class Commands {
    @Environment(value=EnvType.CLIENT)
    public static void registerCommands() {
        Commands.registerSubCommands("MobHealthIndicators");
        Commands.registerSubCommands("mhi");
    }

    private static void registerSubCommandOfBool(ArgumentBuilder<FabricClientCommandSource, ?> argumentBuilder, String name) {
        argumentBuilder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).executes(context -> {
            Commands.sendMessage((class_2561)class_2561.method_43470((String)(name + " is currently set to: " + String.valueOf(Config.getName(name)))));
            return 1;
        })).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean value = (Boolean)context.getArgument("value", Boolean.TYPE);
            Config.setName(name, value);
            Config.save();
            Commands.sendMessage((class_2561)class_2561.method_43470((String)("set " + name + " to " + value)));
            return 1;
        })));
    }

    private static void registerSubCommandOfInt(ArgumentBuilder<FabricClientCommandSource, ?> argumentBuilder, String name, int min, int max) {
        argumentBuilder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).executes(context -> {
            Commands.sendMessage((class_2561)class_2561.method_43470((String)(name + " is currently set to: " + String.valueOf(Config.getName(name)))));
            return 1;
        })).then(ClientCommandManager.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)min, (int)max)).executes(context -> {
            int value = (Integer)context.getArgument("value", Integer.TYPE);
            Config.setName(name, value);
            Config.save();
            Commands.sendMessage((class_2561)class_2561.method_43470((String)("set " + name + " to " + value)));
            return 1;
        })));
    }

    private static void registerSubCommandOfToggleableEntityList(ArgumentBuilder<FabricClientCommandSource, ?> argumentBuilder, String name) {
        Config.ToggleableEntityList list = (Config.ToggleableEntityList)Config.getName(name);
        argumentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).executes(context -> {
            Commands.sendMessage((class_2561)class_2561.method_43470((String)(name + " is currently " + (list.toggle ? "enabled" : "disabled") + " with entities: " + String.valueOf(list.entityList))));
            return 1;
        })).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            list.toggle = (Boolean)context.getArgument("value", Boolean.TYPE);
            Config.save();
            Commands.sendMessage((class_2561)class_2561.method_43470((String)("toggled blackList to " + list.toggle)));
            return 1;
        })))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"value", (ArgumentType)SpecificStringArgumentType.specificString(() -> EntityTypeToEntity.getLivingEntities().stream().map(class_1299::method_5890).map(class_2960::toString).collect(Collectors.toSet()))).executes(context -> {
            String value = (String)context.getArgument("value", String.class);
            list.entityList.add(value);
            Config.save();
            Commands.sendMessage((class_2561)class_2561.method_43470((String)(value + " added to blackList")));
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"value", (ArgumentType)SpecificStringArgumentType.specificString(() -> new HashSet<String>(list.entityList))).executes(context -> {
            String value = (String)context.getArgument("value", String.class);
            list.entityList.remove(value);
            Config.save();
            Commands.sendMessage((class_2561)class_2561.method_43470((String)(value + " removed from blackList")));
            return 1;
        }))));
    }

    private static void registerSubCommands(String mainCommand) {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)ClientCommandManager.literal((String)mainCommand).executes(context -> {
                Commands.sendMessage((class_2561)class_2561.method_43470((String)Config.config.toString()));
                return 1;
            });
            builder.then(ClientCommandManager.literal((String)"config").executes(context -> {
                class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
                client.method_63588(() -> client.method_1507(ConfigScreenHandler.getConfigScreen(client.field_1755)));
                return 1;
            }));
            for (Field f : Config.class.getFields()) {
                if (!f.isAnnotationPresent(Command.class)) continue;
                String name = f.getName();
                Class<?> type = f.getType();
                if (type == Integer.TYPE) {
                    Config.Range range = f.getAnnotation(Config.Range.class);
                    Commands.registerSubCommandOfInt(builder, name, range.min(), range.max());
                    continue;
                }
                if (type == Boolean.TYPE) {
                    Commands.registerSubCommandOfBool(builder, name);
                    continue;
                }
                if (type != Config.ToggleableEntityList.class) continue;
                Commands.registerSubCommandOfToggleableEntityList(builder, name);
            }
            dispatcher.register(builder);
        });
    }

    private static void sendMessage(class_2561 message) {
        assert (class_310.method_1551().field_1724 != null);
        class_310.method_1551().field_1724.method_7353(message, false);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Command {
    }
}

