/*
 * Decompiled with CFR 0.152.
 */
package net.vi.mobhealthindicators.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import net.vi.mobhealthindicators.MobHealthIndicators;
import net.vi.mobhealthindicators.commands.Commands;
import net.vi.mobhealthindicators.config.screen.ConfigScreenHandler;
import net.vi.mobhealthindicators.render.HeartType;

public class Config {
    public static Config config;
    public static Config defaults;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.DISPLAY)
    public boolean showHearts = true;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.DISPLAY, tooltip=true)
    public boolean dynamicBrightness = true;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.DISPLAY)
    @Range(min=-25, max=25)
    public int height = 0;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.DISPLAY, tooltip=true)
    public boolean renderOnTopOnHover = true;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.DISPLAY, tooltip=true)
    public boolean infiniteHoverRange = false;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.FILTER)
    public ToggleableEntityList blackList = new ToggleableEntityList(true, "minecraft:armor_stand");
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.FILTER)
    public ToggleableEntityList whiteList = new ToggleableEntityList(false, "minecraft:player");
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.FILTER)
    public boolean showHostile = true;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.FILTER)
    public boolean showPassive = true;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.FILTER)
    public boolean showSelf = false;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.FILTER)
    public boolean onlyShowDamaged = false;
    @Expose
    @Commands.Command
    @ConfigScreenHandler.ConfigScreen(category=ConfigScreenHandler.Category.FILTER, tooltip=true)
    public boolean onlyShowOnHover = false;
    @Expose
    public HashMap<String, String> entityTypeToEntity = new HashMap();
    private static final Gson GSON;
    private static final File configFile;

    public static void setName(String name, Object value) {
        try {
            Field f = Config.class.getField(name);
            f.set(config, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getDefault(String name) {
        return Config.get(name, defaults);
    }

    public static <T> T getName(String name) {
        return Config.get(name, config);
    }

    private static <T> T get(String name, Object instance) {
        try {
            Field f = Config.class.getField(name);
            return (T)f.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldRender(class_1309 livingEntity, class_1297 targetedEntity) {
        if (MobHealthIndicators.overrideFiltersKey.method_1434()) {
            return true;
        }
        if (!this.showHearts) {
            return false;
        }
        if (livingEntity == MobHealthIndicators.client.field_1724) {
            return this.showSelf;
        }
        if (this.onlyShowOnHover && targetedEntity != livingEntity) {
            return false;
        }
        if (this.onlyShowDamaged && class_3532.method_15386((float)livingEntity.method_6032()) >= class_3532.method_15386((float)livingEntity.method_6063()) && !HeartType.Effect.hasAbnormalHearts(livingEntity)) {
            return false;
        }
        if (this.whiteList.toggle && this.whiteList.entityList.stream().anyMatch(s -> s.equals(class_1299.method_5890((class_1299)livingEntity.method_5864()).toString()))) {
            return true;
        }
        if (this.blackList.toggle && this.blackList.entityList.stream().anyMatch(s -> s.equals(class_1299.method_5890((class_1299)livingEntity.method_5864()).toString()))) {
            return false;
        }
        if (!this.showHostile && livingEntity instanceof class_1569) {
            return false;
        }
        return this.showPassive || livingEntity instanceof class_1569 || livingEntity instanceof class_1657;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Field field : config.getClass().getFields()) {
            if (!field.isAnnotationPresent(Commands.Command.class)) continue;
            try {
                sb.append(field.getName()).append(" = ").append(field.get(config));
            }
            catch (IllegalAccessException e) {
                sb.append(field.getName()).append("=N/A, ");
            }
            sb.append(", \n");
        }
        if (sb.lastIndexOf(", \n") == sb.length() - 3) {
            sb.setLength(sb.length() - 3);
        }
        return sb.toString();
    }

    public static void load() {
        try (FileReader reader = new FileReader(configFile);){
            Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config != null) {
                for (Field f : Config.class.getFields()) {
                    if (!f.isAnnotationPresent(Expose.class) || f.get(config) != null) continue;
                    f.set(config, f.get(defaults));
                }
                Config.config = config;
            } else {
                Config.config = new Config();
                Config.save();
            }
        }
        catch (Exception e) {
            config = new Config();
            Config.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            System.err.println("Could not write to the config file.");
        }
    }

    static {
        defaults = new Config();
        GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
        configFile = FabricLoader.getInstance().getConfigDir().resolve("mobhealthindicators.json").toFile();
        if (!configFile.exists()) {
            try {
                if (!configFile.createNewFile()) {
                    throw new IOException("Failed to create config file.");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ToggleableEntityList {
        @Expose
        public List<String> entityList;
        @Expose
        public boolean toggle;

        public ToggleableEntityList(boolean toggle, String ... entityList) {
            this.entityList = new ArrayList<String>(Arrays.stream(entityList).toList());
            this.toggle = toggle;
        }

        public String toString() {
            return this.entityList.toString() + ", " + this.toggle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Range {
        public int min();

        public int max();
    }
}

