/*
 * Decompiled with CFR 0.152.
 */
package net.vi.mobhealthindicators.config.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_2561;
import net.vi.mobhealthindicators.config.screen.BetterBaseListCell;
import net.vi.mobhealthindicators.config.screen.ToggleableBetterBaseListEntry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToggleableListListEntry<T, C extends AbstractListCell<T, C, SELF>, SELF extends AbstractToggleableListListEntry<T, C, SELF>>
extends ToggleableBetterBaseListEntry<T, C, SELF> {
    protected final BiFunction<T, SELF, C> createNewCell;
    protected Function<T, Optional<class_2561>> cellErrorSupplier;
    protected List<T> original;
    protected boolean originalToggled;

    @ApiStatus.Internal
    public AbstractToggleableListListEntry(class_2561 fieldName, List<T> value, boolean toggled, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, BiConsumer<List<T>, Boolean> saveConsumer, Supplier<List<T>> defaultValue, Supplier<Boolean> defaultToggle, class_2561 resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront, BiFunction<T, SELF, C> createNewCell) {
        super(fieldName, tooltipSupplier, toggled, defaultValue, defaultToggle, abstractListListEntry -> (AbstractListCell)((Object)((Object)createNewCell.apply(null, abstractListListEntry))), saveConsumer, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront);
        this.createNewCell = createNewCell;
        this.original = new ArrayList<T>(value);
        this.originalToggled = toggled;
        for (T f : value) {
            this.cells.add((AbstractListCell)((Object)createNewCell.apply(f, (SELF)((Object)((AbstractToggleableListListEntry)((Object)this.self()))))));
        }
        this.widgets.addAll(this.cells);
        this.setExpanded(defaultExpanded);
    }

    public Function<T, Optional<class_2561>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public void setCellErrorSupplier(Function<T, Optional<class_2561>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
    }

    public List<T> getValue() {
        return this.cells.stream().map(AbstractListCell::getValue).collect(Collectors.toList());
    }

    @Override
    protected C getFromValue(T value) {
        return (C)((Object)((AbstractListCell)((Object)this.createNewCell.apply(value, (SELF)((Object)((AbstractToggleableListListEntry)((Object)this.self())))))));
    }

    @Override
    public boolean isEdited() {
        if (super.isEdited()) {
            return true;
        }
        Object value = this.getValue();
        if (value.size() != this.original.size()) {
            return true;
        }
        for (int i = 0; i < value.size(); ++i) {
            if (Objects.equals(value.get(i), this.original.get(i))) continue;
            return true;
        }
        return this.originalToggled != this.toggled.get();
    }

    public static abstract class AbstractListCell<T, SELF extends AbstractListCell<T, SELF, OUTER_SELF>, OUTER_SELF extends AbstractToggleableListListEntry<T, SELF, OUTER_SELF>>
    extends BetterBaseListCell {
        protected final OUTER_SELF listListEntry;
        protected final Rectangle cellBounds = new Rectangle();

        public AbstractListCell(@Nullable T value, OUTER_SELF listListEntry) {
            this.listListEntry = listListEntry;
            this.setErrorSupplier(() -> Optional.ofNullable(listListEntry.cellErrorSupplier).flatMap(cellErrorFn -> (Optional)cellErrorFn.apply(this.getValue())));
        }

        public abstract T getValue();

        @Override
        public void updateBounds(boolean expanded, int x, int y, int entryWidth, int entryHeight) {
            if (expanded) {
                this.cellBounds.setBounds(x, y, entryWidth, entryHeight);
            } else {
                this.cellBounds.setBounds(0, 0, 0, 0);
            }
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.cellBounds.contains(mouseX, mouseY);
        }
    }
}

