/*
 * Decompiled with CFR 0.152.
 */
package net.vi.mobhealthindicators.config.screen;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_437;
import net.vi.mobhealthindicators.EntityTypeToEntity;
import net.vi.mobhealthindicators.MobHealthIndicators;
import net.vi.mobhealthindicators.config.Config;
import net.vi.mobhealthindicators.config.screen.BetterDropdownBoxEntry;
import net.vi.mobhealthindicators.config.screen.BetterDropdownNoRestListBuilder;
import net.vi.mobhealthindicators.config.screen.ToggleableNestedListListEntry;

public class ConfigScreenHandler {
    public static class_437 getConfigScreen(class_437 parent) {
        ConfigBuilder configBuilder = ConfigBuilder.create();
        configBuilder.setParentScreen(parent);
        configBuilder.setEditable(true);
        configBuilder.setSavingRunnable(Config::save);
        configBuilder.setTitle((class_2561)class_2561.method_43471((String)"mobhealthindicators.name"));
        configBuilder.transparentBackground();
        ConfigEntryBuilder entryBuilder = configBuilder.entryBuilder();
        ConfigCategory display = configBuilder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.mobhealthindicators.category.display"));
        ConfigCategory filter = configBuilder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.mobhealthindicators.category.filter"));
        ConfigCategory keybinds = configBuilder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.mobhealthindicators.category.keybinds"));
        keybinds.addEntry((AbstractConfigListEntry)ConfigScreenHandler.getKeybindingField(entryBuilder, MobHealthIndicators.toggleKey));
        keybinds.addEntry((AbstractConfigListEntry)ConfigScreenHandler.getKeybindingField(entryBuilder, MobHealthIndicators.overrideFiltersKey));
        for (Field f : Config.class.getFields()) {
            ConfigScreen annotation = f.getAnnotation(ConfigScreen.class);
            if (annotation == null) continue;
            String name = f.getName();
            Class<?> type = f.getType();
            ConfigCategory configCategory = null;
            Object entry = null;
            switch (annotation.category().ordinal()) {
                case 0: {
                    configCategory = display;
                    break;
                }
                case 1: {
                    configCategory = filter;
                }
            }
            if (type == Integer.TYPE) {
                Config.Range range = f.getAnnotation(Config.Range.class);
                entry = ConfigScreenHandler.getIntSlider(entryBuilder, name, range.min(), range.max(), annotation.tooltip());
            } else if (type == Boolean.TYPE) {
                entry = ConfigScreenHandler.getBooleanToggle(entryBuilder, name, annotation.tooltip());
            } else if (type == Config.ToggleableEntityList.class) {
                entry = ConfigScreenHandler.getToggleableEntityDropdownList(name, annotation.tooltip());
            }
            configCategory.addEntry((AbstractConfigListEntry)entry);
        }
        return configBuilder.build();
    }

    private static IntegerSliderEntry getIntSlider(ConfigEntryBuilder entryBuilder, String name, int min, int max, boolean tooltip) {
        IntSliderBuilder builder = entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)("config.mobhealthindicators.option." + name.toLowerCase())), ((Integer)Config.getName(name)).intValue(), min, max);
        builder.setDefaultValue(() -> (Integer)Config.getDefault(name));
        builder.setSaveConsumer(value -> Config.setName(name, value));
        if (tooltip) {
            builder.setTooltip(new class_2561[]{class_2561.method_43471((String)("config.mobhealthindicators.option." + name.toLowerCase() + ".tooltip"))});
        }
        return builder.build();
    }

    private static BooleanListEntry getBooleanToggle(ConfigEntryBuilder entryBuilder, String name, boolean tooltip) {
        BooleanToggleBuilder builder = entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)("config.mobhealthindicators.option." + name.toLowerCase())), ((Boolean)Config.getName(name)).booleanValue());
        builder.setDefaultValue(() -> (Boolean)Config.getDefault(name));
        builder.setSaveConsumer(value -> Config.setName(name, value));
        if (tooltip) {
            builder.setTooltip(new class_2561[]{class_2561.method_43471((String)("config.mobhealthindicators.option." + name.toLowerCase() + ".tooltip"))});
        }
        return builder.build();
    }

    private static ToggleableNestedListListEntry<String, ?> getToggleableEntityDropdownList(String name, boolean tooltip) {
        Config.ToggleableEntityList toggleableEntityList = (Config.ToggleableEntityList)Config.getName(name);
        Config.ToggleableEntityList defaultToggleableEntityList = (Config.ToggleableEntityList)Config.getDefault(name);
        BetterDropdownNoRestListBuilder<String> builder = ConfigScreenHandler.startToggleableEntityDropdownList((class_2561)class_2561.method_43471((String)("config.mobhealthindicators.option." + name.toLowerCase())), toggleableEntityList.entityList.stream().toList(), toggleableEntityList.toggle);
        builder.setDefaultValue(() -> defaultToggleableEntityList.entityList.stream().toList());
        builder.setDefaultToggled(() -> defaultToggleableEntityList.toggle);
        builder.setSaveConsumer((list, toggle) -> {
            toggleableEntityList.entityList = list;
            toggleableEntityList.toggle = toggle;
        });
        if (tooltip) {
            builder.setTooltip(new class_2561[]{class_2561.method_43471((String)("config.mobhealthindicators.option." + name.toLowerCase() + ".tooltip"))});
        }
        return builder.build();
    }

    private static KeyCodeEntry getKeybindingField(ConfigEntryBuilder entryBuilder, class_304 keyBinding) {
        return entryBuilder.fillKeybindingField((class_2561)class_2561.method_43471((String)keyBinding.method_1431()), keyBinding).build();
    }

    private static BetterDropdownNoRestListBuilder<String> startToggleableEntityDropdownList(class_2561 fieldNameKey, List<String> value, boolean toggled) {
        BetterDropdownNoRestListBuilder<String> entry = ConfigScreenHandler.startToggleableDropdownList(fieldNameKey, value, toggled, string -> new BetterDropdownBoxEntry.DefaultSelectionTopCellElement<String>(string == null ? "" : string, s -> s, class_2561::method_43470), new BetterDropdownBoxEntry.DefaultSelectionCellCreator());
        entry.setSelections(EntityTypeToEntity.getLivingEntities().stream().map(class_1299::method_5890).map(class_2960::toString).sorted().toList());
        return entry;
    }

    public static <T> BetterDropdownNoRestListBuilder<T> startToggleableDropdownList(class_2561 fieldNameKey, List<T> value, boolean toggled, Function<T, BetterDropdownBoxEntry.SelectionTopCellElement<T>> topCellCreator, BetterDropdownBoxEntry.SelectionCellCreator<T> cellCreator) {
        return new BetterDropdownNoRestListBuilder<T>((class_2561)class_2561.method_43471((String)"text.cloth-config.reset_value"), fieldNameKey, value, toggled, topCellCreator, cellCreator);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigScreen {
        public Category category();

        public boolean tooltip() default false;
    }

    public static enum Category {
        DISPLAY,
        FILTER;

    }
}

