/*
 * Decompiled with CFR 0.152.
 */
package net.vi.mobhealthindicators.render;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.vi.mobhealthindicators.MobHealthIndicators;

public enum HeartType {
    EMPTY("container"),
    FULL("full"),
    HALF("half");

    public final String heartIcon;

    private HeartType(String heartIcon) {
        this.heartIcon = heartIcon;
    }

    public BufferedImage getTexture(Effect effect) {
        try {
            return ImageIO.read(MobHealthIndicators.client.method_1478().getResourceOrThrow(class_2960.method_60655((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + effect.prefix + this.heartIcon + ".png"))).method_14482());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Effect {
        none(""),
        poison("poisoned_"),
        wither("withered_"),
        absorption("absorbing_"),
        frozen("frozen_");

        public final String prefix;

        private Effect(String prefix) {
            this.prefix = prefix;
        }

        public static boolean hasAbnormalHearts(class_1309 entity) {
            return Effect.getEffect(entity) != none || entity.method_6059(class_1294.field_5898) || entity.method_6059(class_1294.field_5914);
        }

        public static Effect getEffect(class_1309 entity) {
            if (entity.method_6059(class_1294.field_5899)) {
                return poison;
            }
            if (entity.method_6059(class_1294.field_5920)) {
                return wither;
            }
            if (entity.method_32314()) {
                return frozen;
            }
            return none;
        }
    }

    public record HeartColor(BufferedImage fullHeartTexture, BufferedImage halfHeartTexture) {
    }
}

