/*
 * Decompiled with CFR 0.152.
 */
package net.vi.mobhealthindicators.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_8646;
import net.minecraft.class_898;
import net.vi.mobhealthindicators.MobHealthIndicators;
import net.vi.mobhealthindicators.config.Config;
import net.vi.mobhealthindicators.render.TextureBuilder;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public abstract class Renderer {
    private static final RenderPipeline FULL_BRIGHT_INDICATORS_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56854}).withLocation(class_2960.method_60655((String)"mobhealthindicators", (String)"pipeline/full_bright_indicators")).withShaderDefine("ALPHA_CUTOUT", 0.1f).withShaderDefine("NO_OVERLAY").withShaderDefine("NO_CARDINAL_LIGHTING").withSampler("Sampler1").withCull(false).build());
    public static final Function<class_2960, class_1921> FULL_BRIGHT_INDICATORS = class_156.method_34866(texture -> {
        class_1921.class_4688 multiPhaseParameters = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false)).method_23608(class_4668.field_21383).method_23611(class_4668.field_21385).method_23617(false);
        return class_1921.method_24049((String)"full_bright_indicators", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)FULL_BRIGHT_INDICATORS_PIPELINE, (class_1921.class_4688)multiPhaseParameters);
    });
    public static final float defaultPixelSize = 0.025f;
    public static float pixelSize = 0.025f;
    public static final int heightDivisor = 50;

    public static void render(class_4587 matrixStack, class_1309 livingEntity, class_2960 texture, int light, double distance, boolean hasLabel, class_898 dispatcher) {
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, livingEntity.method_17682() + 0.5f + (float)Config.config.height / 50.0f, 0.0f);
        if (hasLabel && distance <= 4096.0) {
            matrixStack.method_22904(0.0, (double)(10.349999f * pixelSize), 0.0);
            if (distance < 100.0 && livingEntity.method_73183().method_8428().method_1189(class_8646.field_45158) != null) {
                matrixStack.method_22904(0.0, (double)(10.349999f * pixelSize), 0.0);
            }
        }
        matrixStack.method_22905(pixelSize, pixelSize, pixelSize);
        matrixStack.method_23760().method_23761().rotateY(Renderer.getYaw(dispatcher.field_4686.method_19330()));
        Renderer.draw(matrixStack.method_23760().method_23761(), texture, light, MobHealthIndicators.targetedEntity == livingEntity);
        matrixStack.method_22909();
    }

    private static float getYaw(double yaw) {
        yaw = -Math.toRadians(yaw);
        if ((yaw += Math.PI) > Math.PI) {
            yaw -= Math.PI * 2;
        }
        if (yaw < -Math.PI) {
            yaw += Math.PI * 2;
        }
        return (float)yaw;
    }

    public static void draw(Matrix4f positionMatrix, class_2960 texture, int light, boolean isTargeted) {
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1580);
        class_1011 image = ((class_1043)MobHealthIndicators.client.method_1531().method_4619(texture)).method_4525();
        if (image == null) {
            return;
        }
        Renderer.drawHeart(positionMatrix, (class_4588)bufferBuilder, (float)image.method_4307() / 2.0f, image.method_4323(), Config.config.dynamicBrightness ? light : 0xF000F0);
        class_1921 renderLayer = MobHealthIndicators.areShadersEnabled || Config.config.dynamicBrightness ? class_1921.method_23578((class_2960)texture) : FULL_BRIGHT_INDICATORS.apply(texture);
        boolean offset = GL11.glGetBoolean((int)32823);
        float offset_factor = GL11.glGetFloat((int)32824);
        float offset_units = GL11.glGetFloat((int)10752);
        boolean blend = GL11.glGetBoolean((int)3042);
        if (isTargeted && Config.config.renderOnTopOnHover) {
            GL11.glEnable((int)32823);
            GL11.glPolygonOffset((float)Float.NEGATIVE_INFINITY, (float)Float.NEGATIVE_INFINITY);
            GL11.glDisable((int)3042);
        }
        renderLayer.method_60895(bufferBuilder.method_60800());
        if (isTargeted && Config.config.renderOnTopOnHover) {
            if (!offset) {
                GL11.glDisable((int)32823);
            }
            GL11.glPolygonOffset((float)offset_factor, (float)offset_units);
            if (blend) {
                GL11.glEnable((int)3042);
            }
        }
    }

    private static void drawHeart(Matrix4f matrix4f, class_4588 bufferBuilder, float width, float height, int light) {
        Renderer.drawVertex(matrix4f, bufferBuilder, -width, -TextureBuilder.heartSize, 0.0f, 1.0f, light);
        Renderer.drawVertex(matrix4f, bufferBuilder, width, -TextureBuilder.heartSize, 1.0f, 1.0f, light);
        Renderer.drawVertex(matrix4f, bufferBuilder, width, height - (float)TextureBuilder.heartSize, 1.0f, 0.0f, light);
        Renderer.drawVertex(matrix4f, bufferBuilder, -width, height - (float)TextureBuilder.heartSize, 0.0f, 0.0f, light);
    }

    private static void drawVertex(Matrix4f model, class_4588 bufferBuilder, float x, float y, float u, float v, int light) {
        bufferBuilder.method_22918(model, x, y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 0.0f, 0.0f);
    }
}

