/*
 * Decompiled with CFR 0.152.
 */
package net.vi.mobhealthindicators.render;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.vi.mobhealthindicators.MobHealthIndicators;
import net.vi.mobhealthindicators.render.HeartType;

public class TextureBuilder {
    public static HeartType.HeartColor emptyTexture;
    public static HeartType.HeartColor normalHeart;
    public static HeartType.HeartColor poisonHeart;
    public static HeartType.HeartColor witherHeart;
    public static HeartType.HeartColor absorptionHeart;
    public static HeartType.HeartColor frozenHeart;
    public static final int defaultHeartSize = 9;
    public static int heartSize;
    public static final Map<String, class_2960> textures;
    private static final int heartsPerRow = 10;

    public static class_2960 getTexture(int normalHealth, int maxHealth, int absorptionHealth, HeartType.Effect effect) {
        class_2960 class_29602;
        String healthId = normalHealth + "_" + (maxHealth - normalHealth) + "_" + absorptionHealth + "_" + String.valueOf((Object)effect);
        if (textures.containsKey(healthId)) {
            return textures.get(healthId);
        }
        int normalHearts = class_3532.method_15386((float)((float)normalHealth / 2.0f));
        int maxHearts = class_3532.method_15386((float)((float)maxHealth / 2.0f));
        int absorptionHearts = class_3532.method_15386((float)((float)absorptionHealth / 2.0f));
        int totalHearts = maxHearts + absorptionHearts;
        int heartRows = (int)Math.ceil((float)totalHearts / 10.0f);
        boolean lastNormalHalf = normalHealth % 2 == 1;
        boolean lastAbsorptionHalf = absorptionHealth % 2 == 1;
        int heartDensity = Math.max(10 - (heartRows - 2), 3);
        int yPixelsTotal = (heartRows - 1) * heartDensity + heartSize;
        int xPixelsTotal = Math.min(totalHearts, 10) * (heartSize - 1) + 1;
        BufferedImage healthBar = new BufferedImage(xPixelsTotal, yPixelsTotal, 2);
        Graphics graphics = healthBar.getGraphics();
        for (int heart = totalHearts - 1; heart >= 0; --heart) {
            TextureBuilder.addHeart(graphics, emptyTexture.fullHeartTexture(), heartRows, heartDensity, heart, heartSize);
            BufferedImage heartTexture = TextureBuilder.getHeartTexture(heart, totalHearts, maxHearts, normalHearts, lastNormalHalf, lastAbsorptionHalf, effect);
            if (heartTexture == null) continue;
            TextureBuilder.addHeart(graphics, heartTexture, heartRows, heartDensity, heart, heartSize);
        }
        graphics.dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)healthBar, "png", byteArrayOutputStream);
            class_1043 texture = new class_1043(() -> "hearts", class_1011.method_49277((byte[])byteArrayOutputStream.toByteArray()));
            texture.method_4527(false, false);
            texture.method_4524();
            class_2960 identifier = class_2960.method_60655((String)"mobhealthindicators", (String)healthId);
            textures.put(healthId, identifier);
            MobHealthIndicators.client.method_1531().method_4616(identifier, (class_1044)texture);
            class_29602 = identifier;
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        byteArrayOutputStream.close();
        return class_29602;
    }

    public static BufferedImage getHeartTexture(int currentHeart, int totalHearts, int maxNormalHearts, int normalHearts, boolean lastNormalHalf, boolean lastAbsorptionHalf, HeartType.Effect effect) {
        HeartType.HeartColor heartColor = null;
        boolean isHalf = false;
        if (currentHeart < normalHearts) {
            isHalf = currentHeart == normalHearts - 1 && lastNormalHalf;
            switch (effect) {
                case none: 
                case absorption: {
                    heartColor = normalHeart;
                    break;
                }
                case poison: {
                    heartColor = poisonHeart;
                    break;
                }
                case wither: {
                    heartColor = witherHeart;
                    break;
                }
                case frozen: {
                    heartColor = frozenHeart;
                }
            }
        } else if (currentHeart < maxNormalHearts) {
            heartColor = emptyTexture;
        } else {
            isHalf = currentHeart == totalHearts - 1 && lastAbsorptionHalf;
            heartColor = absorptionHeart;
        }
        return isHalf ? heartColor.halfHeartTexture() : heartColor.fullHeartTexture();
    }

    private static void addHeart(Graphics graphics, Image image, int heartRows, int heartDensity, int heart, int heartSize) {
        graphics.drawImage(image, heart % 10 * (heartSize - 1), (heartRows - heart / 10 - 1) * heartDensity, heartSize, heartSize, null);
    }

    static {
        textures = new HashMap<String, class_2960>();
    }
}

