/*
 * Decompiled with CFR 0.152.
 */
package mod.etie09.etieschallengesmod;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.etie09.etieschallengesmod.Timer.Timer;
import mod.etie09.etieschallengesmod.challenges.Challenge;
import mod.etie09.etieschallengesmod.challenges.MovementSpeedChallenge;
import mod.etie09.etieschallengesmod.challenges.RandomItemChallenge;
import mod.etie09.etieschallengesmod.challenges.none;
import mod.etie09.etieschallengesmod.command.ChallengeCommand;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5894;
import net.minecraft.server.MinecraftServer;

public class Etieschallengesmod
implements ModInitializer {
    private static MinecraftServer serverInstance;
    private static Challenge currentChallenge;
    private static final Set<String> CHALLENGE_NAMES;
    public static final String MOD_ID = "etieschallengesmod";
    private static final Timer challengeTimer;
    private static boolean isTimerPaused;
    private static boolean isPlayerFrozen;
    private static final Map<UUID, class_243> playerPositions;
    private static boolean isInitialized;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            serverInstance = server;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (!isInitialized) {
                Etieschallengesmod.stopChallenge();
                isInitialized = true;
            }
            challengeTimer.tick();
            if (currentChallenge != null) {
                currentChallenge.tick();
            }
            if (isPlayerFrozen && serverInstance != null) {
                for (class_3222 player : serverInstance.method_3760().method_14571()) {
                    class_243 lastPosition;
                    if (!playerPositions.containsKey(player.method_5667())) {
                        playerPositions.put(player.method_5667(), player.method_19538());
                        player.method_7336(class_1934.field_9216);
                    }
                    if ((lastPosition = playerPositions.get(player.method_5667())) == null) continue;
                    player.method_5859(lastPosition.field_1352, lastPosition.field_1351, lastPosition.field_1350);
                }
            }
            if (server.method_3780() % 20 == 0 && serverInstance != null) {
                class_2561 formattedTime = challengeTimer.getFormattedTime();
                for (class_3222 player : serverInstance.method_3760().method_14571()) {
                    player.field_13987.method_14364((class_2596)new class_5894(formattedTime));
                }
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ChallengeCommand.register((CommandDispatcher<class_2168>)dispatcher, CHALLENGE_NAMES));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (playerPositions.containsKey(oldPlayer.method_5667())) {
                class_243 lastPosition = playerPositions.get(oldPlayer.method_5667());
                newPlayer.method_5859(lastPosition.field_1352, lastPosition.field_1351, lastPosition.field_1350);
                newPlayer.method_6092(new class_1293(class_1294.field_5905, 200, 0, false, false, false));
                newPlayer.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Du wurdest zu deiner letzten Position teleportiert."));
            }
        });
        System.out.println("EtiesChallengesMod loaded!");
    }

    public static boolean startChallenge(String challengeName, class_3222 initiatingPlayer) {
        if (currentChallenge != null) {
            currentChallenge.stop();
        }
        switch (challengeName) {
            case "none": {
                currentChallenge = new none();
                break;
            }
            case "movement_speed": {
                currentChallenge = new MovementSpeedChallenge();
                break;
            }
            case "random_item": {
                currentChallenge = new RandomItemChallenge();
                break;
            }
            default: {
                currentChallenge = null;
                return false;
            }
        }
        if (currentChallenge != null) {
            currentChallenge.setServer(serverInstance);
            currentChallenge.start();
            challengeTimer.start();
            isTimerPaused = false;
            isPlayerFrozen = false;
            if (serverInstance != null) {
                serverInstance.method_3760().method_14571().forEach(player -> player.method_7336(class_1934.field_9215));
            }
            playerPositions.clear();
            return true;
        }
        return false;
    }

    public static boolean stopChallenge() {
        if (currentChallenge != null) {
            currentChallenge.stop();
            currentChallenge = null;
        }
        challengeTimer.stop();
        isTimerPaused = true;
        isPlayerFrozen = true;
        if (serverInstance != null) {
            serverInstance.method_3760().method_14571().forEach(player -> {
                player.method_7336(class_1934.field_9216);
                playerPositions.put(player.method_5667(), player.method_19538());
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cChallenge gestoppt!"));
            });
        }
        return true;
    }

    public static boolean pauseChallenge() {
        if (!isTimerPaused) {
            if (serverInstance != null) {
                for (class_3222 player : serverInstance.method_3760().method_14571()) {
                    playerPositions.put(player.method_5667(), player.method_19538());
                    player.method_7336(class_1934.field_9216);
                }
            }
            if (currentChallenge != null) {
                currentChallenge.pause();
            }
            isTimerPaused = true;
            isPlayerFrozen = true;
            challengeTimer.pause();
            return true;
        }
        return false;
    }

    public static boolean resumeChallenge() {
        if (currentChallenge != null && isTimerPaused) {
            currentChallenge.resume();
            isTimerPaused = false;
            isPlayerFrozen = false;
            challengeTimer.resume();
            if (serverInstance != null) {
                for (class_3222 player : serverInstance.method_3760().method_14571()) {
                    player.method_7336(class_1934.field_9215);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean testChallenge() {
        if (currentChallenge instanceof MovementSpeedChallenge) {
            ((MovementSpeedChallenge)currentChallenge).skipWait();
            return true;
        }
        if (currentChallenge instanceof RandomItemChallenge) {
            ((RandomItemChallenge)currentChallenge).skipWait();
            return true;
        }
        return false;
    }

    static {
        CHALLENGE_NAMES = Stream.of("none", "movement_speed", "random_item").collect(Collectors.toSet());
        challengeTimer = new Timer();
        isTimerPaused = true;
        isPlayerFrozen = true;
        playerPositions = new HashMap<UUID, class_243>();
        isInitialized = false;
    }
}

