/*
 * Decompiled with CFR 0.152.
 */
package mod.etie09.etieschallengesmod.challenges;

import java.util.List;
import java.util.Random;
import mod.etie09.etieschallengesmod.challenges.Challenge;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class MovementSpeedChallenge
implements Challenge {
    private static final class_2960 SPEED_MODIFIER_ID = class_2960.method_60655((String)"etieschallengesmod", (String)"movement_speed_bonus");
    private MinecraftServer server;
    private List<class_3222> players;
    private boolean running = false;
    private double speedBonus;
    private final double minStartPenalty = -0.1;
    private final double maxStartPenalty = -0.05;
    private final double minIncrease = 0.005;
    private final double maxIncrease = 0.1;
    private int ticksUntilNextIncrease;
    private final Random random = new Random();
    private boolean firstPhase = true;

    @Override
    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return "movement_speed";
    }

    @Override
    public void start() {
        this.running = true;
        this.firstPhase = true;
        this.speedBonus = 0.0;
        this.ticksUntilNextIncrease = 6000;
        if (this.server != null) {
            this.players = this.server.method_3760().method_14571();
            this.players.forEach(player -> player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aMovement Speed Challenge gestartet! In 5 Minuten wirst du langsamer.")));
        }
    }

    @Override
    public void pause() {
        this.running = false;
        if (this.server != null) {
            for (class_3222 player : this.players) {
                this.removeSpeedModifier(player);
            }
        }
    }

    @Override
    public void resume() {
        this.running = true;
        if (this.server != null) {
            for (class_3222 player : this.players) {
                this.setSpeedModifier(player, this.speedBonus);
            }
        }
    }

    @Override
    public void stop() {
        this.running = false;
        if (this.server != null) {
            this.server.method_3760().method_14571().forEach(player -> {
                this.removeSpeedModifier((class_3222)player);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cMovement Speed Challenge gestoppt."));
            });
        }
    }

    @Override
    public void tick() {
        if (!this.running || this.server == null) {
            return;
        }
        if (this.ticksUntilNextIncrease <= 0) {
            if (this.firstPhase) {
                double penalty = -0.1 + 0.05 * this.random.nextDouble();
                this.speedBonus += penalty;
                this.firstPhase = false;
                for (class_3222 player : this.players) {
                    this.setSpeedModifier(player, this.speedBonus);
                    class_1324 attr = player.method_5996(class_5134.field_23719);
                    double finalSpeed = attr != null ? attr.method_6194() : 0.0;
                    player.method_64398((class_2561)class_2561.method_43470((String)String.format("\u00a7eBewegungstempo verringert um %.3f! Aktuell: %.3f", -penalty, finalSpeed)));
                }
            } else {
                double increase = 0.005 + 0.095 * this.random.nextDouble();
                this.speedBonus += increase;
                for (class_3222 player : this.players) {
                    this.setSpeedModifier(player, this.speedBonus);
                    class_1324 attr = player.method_5996(class_5134.field_23719);
                    double finalSpeed = attr != null ? attr.method_6194() : 0.0;
                    player.method_64398((class_2561)class_2561.method_43470((String)String.format("\u00a7eBewegungstempo erh\u00f6ht um %.3f! Aktuell: %.3f", increase, finalSpeed)));
                }
            }
            this.ticksUntilNextIncrease = this.getRandomTicks();
        } else {
            --this.ticksUntilNextIncrease;
        }
    }

    @Override
    public void skipWait() {
        this.ticksUntilNextIncrease = 0;
    }

    private int getRandomTicks() {
        int min = 6000;
        int max = 18000;
        return min + this.random.nextInt(max - min + 1);
    }

    private void setSpeedModifier(class_3222 player, double amount) {
        class_1324 attr = player.method_5996(class_5134.field_23719);
        if (attr == null) {
            return;
        }
        attr.method_6200(SPEED_MODIFIER_ID);
        class_1322 mod = new class_1322(SPEED_MODIFIER_ID, amount, class_1322.class_1323.field_6328);
        attr.method_26837(mod);
    }

    private void removeSpeedModifier(class_3222 player) {
        class_1324 attr = player.method_5996(class_5134.field_23719);
        if (attr != null) {
            attr.method_6200(SPEED_MODIFIER_ID);
        }
    }
}

