/*
 * Decompiled with CFR 0.152.
 */
package mod.etie09.etieschallengesmod.challenges;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import mod.etie09.etieschallengesmod.challenges.Challenge;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class RandomItemChallenge
implements Challenge {
    private MinecraftServer server;
    private boolean running = false;
    private int ticksUntilNextItem;
    private final Random random = new Random();
    private static final int ITEM_GIVE_INTERVAL = 1200;
    private static final int MAX_STACK_SIZE_FOR_TESTS = 127;
    private final Map<UUID, Integer> playerStackVotes = new HashMap<UUID, Integer>();
    private int finalStackSize = 1;

    @Override
    public String getName() {
        return "random_item";
    }

    @Override
    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void start() {
        this.running = true;
        this.ticksUntilNextItem = 1200;
        if (this.server != null) {
            this.server.method_3760().method_14571().forEach(player -> player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aRandom Item Challenge gestartet! Du erh\u00e4ltst alle 60 Sekunden ein zuf\u00e4lliges Item.")));
        }
    }

    @Override
    public void pause() {
        this.running = false;
        if (this.server != null) {
            this.server.method_3760().method_14571().forEach(player -> player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eRandom Item Challenge pausiert.")));
        }
    }

    @Override
    public void resume() {
        this.running = true;
        if (this.server != null) {
            this.server.method_3760().method_14571().forEach(player -> player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aRandom Item Challenge fortgesetzt.")));
        }
    }

    @Override
    public void stop() {
        this.running = false;
        if (this.server != null) {
            this.server.method_3760().method_14571().forEach(player -> player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cRandom Item Challenge gestoppt.")));
        }
    }

    @Override
    public void tick() {
        if (!this.running || this.server == null) {
            return;
        }
        if (this.ticksUntilNextItem <= 0) {
            this.giveRandomItemToPlayers();
            this.ticksUntilNextItem = 1200;
        } else {
            --this.ticksUntilNextItem;
        }
    }

    @Override
    public void skipWait() {
    }

    private void giveRandomItemToPlayers() {
        if (this.server == null) {
            return;
        }
        List players = this.server.method_3760().method_14571();
        List allItems = class_7923.field_41178.method_10220().toList();
        if (allItems.isEmpty()) {
            System.err.println("Keine Items im Register gefunden.");
            return;
        }
        class_1792 randomItem = (class_1792)allItems.get(this.random.nextInt(allItems.size()));
        for (class_3222 player : players) {
            class_1799 stack = new class_1799((class_1935)randomItem, this.finalStackSize);
            player.method_31548().method_7394(stack);
            String itemNameKey = randomItem.method_7876();
            class_5250 itemName = class_2561.method_43471((String)itemNameKey);
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7bDu hast ein zuf\u00e4lliges Item erhalten: ").method_10852((class_2561)itemName));
        }
    }

    public Map<UUID, Integer> getPlayerStackVotes() {
        return this.playerStackVotes;
    }

    public void addStackVote(UUID playerUUID, int stackSize) {
        if (stackSize > 0 && stackSize <= 64) {
            this.playerStackVotes.put(playerUUID, stackSize);
        }
    }

    public void calculateFinalStackSize() {
        if (this.playerStackVotes.isEmpty()) {
            this.finalStackSize = 1;
            return;
        }
        AtomicInteger sum = new AtomicInteger();
        this.playerStackVotes.values().forEach(sum::addAndGet);
        this.finalStackSize = sum.get() / this.playerStackVotes.size();
    }
}

