/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.compat.create_factory_logistics;

import com.krei.cmpackagecouriers.plane.CardboardPlaneItemRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.FluidRenderHelper;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class JarPlaneRenderer {
    public static final FluidRenderHelper<FluidStack> FLUID_RENDERER = CatnipServices.FLUID_RENDERER;

    public static void renderJar(ItemStack box, PoseStack ms, MultiBufferSource buffer, int light) {
        ms.pushPose();
        ms.scale(1.25f, 1.25f, 1.25f);
        ms.pushPose();
        ms.translate(-0.25, -0.25, 0.0);
        ms.mulPose(Axis.ZP.rotationDegrees(90.0f));
        PartialModel model = (PartialModel)AllPartialModels.PACKAGES.get(BuiltInRegistries.ITEM.getKey((Object)box.getItem()));
        if (model != null) {
            ((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)model, (BlockState)Blocks.AIR.defaultBlockState()).translate(-0.5, (double)(-PackageItem.getHeight((ItemStack)box)), -0.5)).rotateCentered(-AngleHelper.rad((double)180.0), Direction.UP)).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutout()));
        }
        ms.popPose();
        ms.pushPose();
        ms.translate(-0.075, 0.0, 0.0);
        float scaleFactor = PackageItem.getHeight((ItemStack)box) / 0.75f;
        ms.scale(scaleFactor, scaleFactor, scaleFactor);
        ms.translate(0.0, -0.25, 0.0);
        PartialModel rope = CardboardPlaneItemRenderer.PACKAGE_ROPE.get(BuiltInRegistries.ITEM.getKey((Object)PackageStyles.getDefaultBox().getItem()));
        if (rope != null) {
            ((SuperByteBuffer)CachedBuffers.partial((PartialModel)rope, (BlockState)Blocks.AIR.defaultBlockState()).translate(-0.5, (double)(-PackageItem.getHeight((ItemStack)box)), -0.5)).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutout()));
        }
        ms.popPose();
        ms.pushPose();
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)box).orElse(FluidStack.EMPTY);
        ms.scale(0.9f, 0.9f, 0.9f);
        ms.translate(-0.375f, -0.5f, -0.25f);
        FLUID_RENDERER.renderFluidBox((Object)fluidStack, 0.0f, 0.0f, 0.0f, 0.625f, 0.5f, 0.5f, buffer, ms, light, true, true);
        ms.popPose();
        ms.popPose();
    }
}

