/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.marker;

import com.simibubi.create.content.logistics.box.PackageItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="cmpackagecouriers")
public class AddressMarkerHandler {
    public static Map<MarkerTarget, MarkerTarget> markerMap = new HashMap<MarkerTarget, MarkerTarget>();

    public static void addOrUpdateTarget(Level level, BlockPos pos, String address) {
        MarkerTarget marker = new MarkerTarget(level, pos, address);
        if (markerMap.containsKey(marker)) {
            marker = markerMap.get(marker);
            marker.resetTimeout();
        } else {
            markerMap.put(marker, marker);
        }
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post event) {
        Iterator<Map.Entry<MarkerTarget, MarkerTarget>> iterator = markerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MarkerTarget, MarkerTarget> entry = iterator.next();
            MarkerTarget marker = entry.getValue();
            if (!marker.tickAndCheckTimeout()) continue;
            iterator.remove();
        }
    }

    @Nullable
    public static MarkerTarget getMarkerTarget(String address) {
        for (MarkerTarget marker : markerMap.values()) {
            if (!PackageItem.matchAddress((String)address, (String)marker.address)) continue;
            return marker;
        }
        return null;
    }

    public static class MarkerTarget {
        public static final int TIMEOUT_TICKS = 20;
        public final BlockPos pos;
        public final Level level;
        public final String address;
        private int timeout = 20;

        public MarkerTarget(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull String address) {
            this.level = level;
            this.pos = pos;
            this.address = address;
        }

        public boolean tickAndCheckTimeout() {
            --this.timeout;
            return this.timeout < 0;
        }

        public void resetTimeout() {
            this.timeout = 20;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MarkerTarget)) {
                return false;
            }
            MarkerTarget other = (MarkerTarget)obj;
            return Objects.equals(this.pos, other.pos) && Objects.equals(this.level.dimension(), other.level.dimension()) && Objects.equals(this.address, other.address);
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.level.dimension(), this.address);
        }

        public String toString() {
            return "(" + this.address + ": " + String.valueOf(this.pos) + ")";
        }
    }
}

