/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.plane;

import com.krei.cmpackagecouriers.compat.create_factory_logistics.FactoryLogisticsCompat;
import com.krei.cmpackagecouriers.compat.create_factory_logistics.JarPlaneRenderer;
import com.krei.cmpackagecouriers.plane.CardboardPlaneItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class CardboardPlaneItemRenderer
extends CustomRenderedItemModelRenderer {
    public static final PartialModel DELIVERY_PLANE = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cmpackagecouriers", (String)"item/cardboard_plane"));
    public static final Map<ResourceLocation, PartialModel> PACKAGE_ROPE = new HashMap<ResourceLocation, PartialModel>();

    public static ResourceLocation getRopeModel(int width, int height) {
        String size = width + "x" + height;
        return ResourceLocation.fromNamespaceAndPath((String)"cmpackagecouriers", (String)("item/rope_" + size));
    }

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ItemStack box = CardboardPlaneItem.getPackage(stack);
        if (box.isEmpty() || !PackageItem.isPackage((ItemStack)box)) {
            box = PackageStyles.getDefaultBox();
        }
        ms.pushPose();
        if (transformType == ItemDisplayContext.GUI) {
            ms.translate(-0.2f, -0.3f, 0.0f);
            ms.scale(0.3f, 0.3f, 0.3f);
        } else if (transformType.firstPerson()) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.isUsingItem()) {
                ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
                ms.mulPose(Axis.ZP.rotationDegrees(-120.0f));
                ms.mulPose(Axis.XP.rotationDegrees(-10.0f));
                ms.translate(1.0f, -0.5f, 0.0f);
                ms.scale(0.5f, 0.5f, 0.5f);
            } else {
                ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                ms.translate(0.25f, -0.4f, 0.0f);
                ms.scale(0.5f, 0.5f, 0.5f);
            }
        } else if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            ms.mulPose(Axis.YP.rotationDegrees(90.0f));
            ms.translate(0.25f, -0.75f, 0.0f);
            ms.scale(0.33333334f, 0.33333334f, 0.33333334f);
            ms.translate(0.0f, PackageItem.getHeight((ItemStack)box), 0.0f);
        } else if (transformType == ItemDisplayContext.GROUND) {
            ms.translate(0.0f, -0.5f, 0.0f);
            ms.scale(0.25f, 0.25f, 0.25f);
            ms.translate(0.0f, PackageItem.getHeight((ItemStack)box), 0.0f);
        } else {
            ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            ms.translate(0.0f, -0.25f, 0.5f);
            ms.translate(0.0f, PackageItem.getHeight((ItemStack)box), 0.0f);
        }
        CardboardPlaneItemRenderer.renderPlane(box, ms, buffer, light);
        ms.popPose();
    }

    public static void renderPlane(ItemStack box, PoseStack ms, MultiBufferSource buffer, int light) {
        if (box.isEmpty() || !PackageItem.isPackage((ItemStack)box)) {
            box = AllBlocks.CARDBOARD_BLOCK.asStack();
        }
        ms.pushPose();
        ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
        ((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)DELIVERY_PLANE, (BlockState)Blocks.AIR.defaultBlockState()).light(light).translate(-1.5f, 0.0f, -1.0f)).scale(3.0f)).renderInto(ms, buffer.getBuffer(RenderType.cutout()));
        ms.popPose();
        ms.pushPose();
        if (ModList.get().isLoaded("create_factory_logistics") && FactoryLogisticsCompat.isJar(box)) {
            JarPlaneRenderer.renderJar(box, ms, buffer, light);
        } else {
            PartialModel rope;
            PartialModel model = (PartialModel)AllPartialModels.PACKAGES.get(BuiltInRegistries.ITEM.getKey((Object)box.getItem()));
            if (model != null) {
                ((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)model, (BlockState)Blocks.AIR.defaultBlockState()).translate(-0.5, (double)(-PackageItem.getHeight((ItemStack)box)), -0.5)).rotateCentered(-AngleHelper.rad((double)180.0), Direction.UP)).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutout()));
            }
            if ((rope = PACKAGE_ROPE.get(BuiltInRegistries.ITEM.getKey((Object)box.getItem()))) != null) {
                ((SuperByteBuffer)CachedBuffers.partial((PartialModel)rope, (BlockState)Blocks.AIR.defaultBlockState()).translate(-0.5, (double)(-PackageItem.getHeight((ItemStack)box)), -0.5)).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutout()));
            }
        }
        ms.popPose();
    }

    public static void init() {
    }

    static {
        for (PackageStyles.PackageStyle style : PackageStyles.STYLES) {
            ResourceLocation key = style.getItemId();
            PACKAGE_ROPE.put(key, PartialModel.of((ResourceLocation)CardboardPlaneItemRenderer.getRopeModel(style.width(), style.height())));
        }
    }
}

