/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.stock_ticker;

import com.krei.cmpackagecouriers.stock_ticker.PortableStockTickerMenu;
import com.krei.cmpackagecouriers.stock_ticker.PortableStockTickerReg;
import com.krei.cmpackagecouriers.stock_ticker.StockCheckingItem;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;

public class PortableStockTicker
extends StockCheckingItem {
    public Map<UUID, List<Integer>> hiddenCategoriesByPlayer;
    protected String previouslyUsedAddress;
    protected List<ItemStack> categories = new ArrayList<ItemStack>();

    public PortableStockTicker(Item.Properties pProperties) {
        super(pProperties.stacksTo(1));
        this.hiddenCategoriesByPlayer = new HashMap<UUID, List<Integer>>();
    }

    public static ItemStack find(Inventory playerInventory) {
        ItemStack pst = playerInventory.player.getMainHandItem();
        if (playerInventory.player.getMainHandItem().getItem() instanceof PortableStockTicker) {
            return pst;
        }
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack portableStockTicker = playerInventory.getItem(i);
            if (!(playerInventory.getItem(i).getItem() instanceof PortableStockTicker)) continue;
            return portableStockTicker;
        }
        return null;
    }

    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, GenericOrder order, IdentifiedInventory ignoredHandler, String address, Player player) {
        ItemStack itemStack;
        boolean result = super.broadcastPackageRequest(type, order, ignoredHandler, address);
        this.previouslyUsedAddress = address;
        if (player instanceof ServerPlayer && (itemStack = PortableStockTicker.find(player.getInventory())) != null && itemStack.getItem() instanceof PortableStockTicker) {
            this.saveAddressToStack(itemStack, address);
        }
        return result;
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide() && player.isShiftKeyDown()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof StockTickerBlockEntity) {
                StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
                CompoundTag tag = new CompoundTag();
                stbe.saveAdditional(tag, (HolderLookup.Provider)level.registryAccess());
                this.categories = NBTHelper.readItemList((ListTag)tag.getList("Categories", 10), (HolderLookup.Provider)level.registryAccess());
            } else if (level.getBlockEntity(pos) instanceof PackagerLinkBlockEntity) {
                this.categories = new ArrayList<ItemStack>();
            }
            this.saveCategoriesToStack(stack, this.categories);
            this.saveHiddenCategoriesByPlayerToStack(stack, this.hiddenCategoriesByPlayer);
            return super.useOn(pContext);
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        this.previouslyUsedAddress = this.loadAddressFromStack(stack);
        this.categories = this.loadCategoriesFromStack(stack);
        this.hiddenCategoriesByPlayer = this.getHiddenCategoriesByPlayerFromStack(stack);
        if (!pLevel.isClientSide) {
            if (!PortableStockTicker.isTuned(stack)) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"item.cmpackagecouriers.portable_stock_ticker.not_linked"), true);
                return InteractionResultHolder.success((Object)pPlayer.getItemInHand(pUsedHand));
            }
            SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, p) -> new PortableStockTickerMenu(id, inv), (Component)Component.translatable((String)"item.cmpackagecouriers.portable_stock_ticker"));
            pPlayer.openMenu((MenuProvider)provider);
            return InteractionResultHolder.success((Object)pPlayer.getItemInHand(pUsedHand));
        }
        return InteractionResultHolder.success((Object)pPlayer.getItemInHand(pUsedHand));
    }

    public void saveAddressToStack(ItemStack stack, String address) {
        if (address != null && !address.isEmpty()) {
            stack.set(PortableStockTickerReg.ADDRESS_TAG, (Object)address);
        }
    }

    public String loadAddressFromStack(ItemStack stack) {
        return (String)stack.getOrDefault(PortableStockTickerReg.ADDRESS_TAG, null);
    }

    public void saveCategoriesToStack(ItemStack stack, List<ItemStack> categories) {
        if (categories != null) {
            stack.set(PortableStockTickerReg.CATEGORIES, categories);
        }
    }

    public List<ItemStack> loadCategoriesFromStack(ItemStack stack) {
        ArrayList<ItemStack> readCategories = new ArrayList<ItemStack>((Collection)stack.getOrDefault(PortableStockTickerReg.CATEGORIES, List.of()));
        readCategories.removeIf(itemStack -> !itemStack.isEmpty() && !(itemStack.getItem() instanceof FilterItem));
        return readCategories;
    }

    public void saveHiddenCategoriesByPlayerToStack(ItemStack stack, Map<UUID, List<Integer>> hiddenCategoriesByPlayer) {
        if (hiddenCategoriesByPlayer != null) {
            stack.set(PortableStockTickerReg.HIDDEN_CATEGORIES, hiddenCategoriesByPlayer);
        }
    }

    public Map<UUID, List<Integer>> getHiddenCategoriesByPlayerFromStack(ItemStack stack) {
        return (Map)stack.getOrDefault(PortableStockTickerReg.HIDDEN_CATEGORIES, new HashMap());
    }
}

