/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plagatesummon;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClaimChunkHelper {
    private static ClaimChunkHelper instance;
    private final ClaimedChunkManager claimedChunkManager;
    private static final Logger LOGGER;

    public ClaimChunkHelper(ClaimedChunkManager claimedChunkManager) {
        this.claimedChunkManager = claimedChunkManager;
    }

    public static ClaimChunkHelper getInstance(MinecraftServer server) throws CommandSyntaxException {
        if (instance == null) {
            instance = new ClaimChunkHelper(FTBChunksAPI.api().getManager());
        }
        return instance;
    }

    public void unClaimChunk(CommandSourceStack source, BlockPos pos, UUID teamUUID, GatewayEntity gatewayEntity) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ResourceKey dimension = gatewayEntity.m_9236_().m_46472_();
        ChunkDimPos chunkDimPos = new ChunkDimPos(dimension, chunkPos.f_45578_, chunkPos.f_45579_);
        Optional ftbTeam = FTBTeamsAPI.api().getManager().getTeamByID(teamUUID);
        ftbTeam.ifPresent(team -> {
            ChunkTeamData teamData = this.claimedChunkManager.getOrCreateData(team);
            teamData.unclaim(source, chunkDimPos, false);
        });
    }

    public void unForceLoadChunk(CommandSourceStack source, BlockPos pos, UUID teamUUID, GatewayEntity gatewayEntity) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ResourceKey dimension = gatewayEntity.m_9236_().m_46472_();
        ChunkDimPos chunkDimPos = new ChunkDimPos(dimension, chunkPos.f_45578_, chunkPos.f_45579_);
        Optional ftbTeam = FTBTeamsAPI.api().getManager().getTeamByID(teamUUID);
        ftbTeam.ifPresent(team -> {
            ChunkTeamData teamData = this.claimedChunkManager.getOrCreateData(team);
            teamData.unForceLoad(source, chunkDimPos, false);
        });
    }

    public void processClaim(CommandSourceStack source, ServerPlayer player, BlockPos pos, GatewayEntity gatewayEntity) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ResourceKey dimension = player.m_9236_().m_46472_();
        ChunkDimPos chunkDimPos = new ChunkDimPos(dimension, chunkPos.f_45578_, chunkPos.f_45579_);
        ChunkTeamData teamData = this.claimedChunkManager.getOrCreateData(player);
        if (!teamData.claim(source, chunkDimPos, false).equals(ClaimResult.StandardProblem.ALREADY_CLAIMED)) {
            teamData.forceLoad(source, chunkDimPos, false);
            gatewayEntity.getPersistentData().m_128359_("CleanUpAction", "full");
            gatewayEntity.getPersistentData().m_128362_("UnClaimUUID", teamData.getTeam().getTeamId());
        } else {
            ChunkTeamData forceLoadTeam;
            ClaimedChunk chunk = this.claimedChunkManager.getChunk(chunkDimPos);
            if (chunk != null && !(forceLoadTeam = chunk.getTeamData()).forceLoad(source, chunkDimPos, false).equals(ClaimResult.StandardProblem.ALREADY_LOADED)) {
                gatewayEntity.getPersistentData().m_128359_("CleanUpAction", "half");
                gatewayEntity.getPersistentData().m_128362_("UnClaimUUID", forceLoadTeam.getTeam().getTeamId());
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

