/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plagatesummon;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.plagatesummon.Config;
import com.pla.plagatesummon.GateSpawnData;
import com.pla.plagatesummon.SurfaceSpawnHelper;
import com.pla.plagatesummon.WaypointHelper;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="plagatesummon")
public class DailyGateSpawner {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random random = new Random();
    public static ServerPlayer randomPlayer = null;
    public static CommandSourceStack source = null;

    static void resetValue(GateSpawnData data, boolean skippedDay) {
        data.shouldSpawnToday = false;
        data.nextSpawnTick = -1;
        data.spawnPos = null;
        data.isPromptPlayer = false;
        data.skippedToday = skippedDay;
        data.spawnChance = (Integer)Config.SPAWN_RATE.get();
        data.dayPassed = 1;
        data.m_77762_();
        randomPlayer = null;
        source = null;
    }

    static void prepareForSpawning(GateSpawnData data, ServerLevel world, MinecraftServer server, CommandSourceStack source, boolean debug_mode) {
        data.shouldSpawnToday = true;
        data.nextSpawnTick = (120 + random.nextInt(2280)) * 10;
        data.spawnPos = SurfaceSpawnHelper.findRandomSurfacePos(world, randomPlayer.m_20183_(), 50, 300);
        server.m_6846_().m_240416_((Component)Component.m_237113_((String)"The gate will open today\u2026 but to where?").m_130940_(ChatFormatting.LIGHT_PURPLE), false);
        if (debug_mode) {
            LOGGER.info("PlaGateSummon: Random gate will be spawned today at " + data.nextSpawnTick + " x: " + data.spawnPos.m_123341_() + " y: " + data.spawnPos.m_123342_() + " z: " + data.spawnPos.m_123343_());
        }
        data.m_77762_();
    }

    static GatewayEntity getGateway(ServerLevel world, String gatewayId) {
        try {
            ResourceLocation type = new ResourceLocation(gatewayId);
            DynamicHolder holder = GatewayRegistry.INSTANCE.holder(type);
            if (!holder.isBound()) {
                LOGGER.error("PlaGateSummon: Unknown Gateway: {}", (Object)gatewayId);
            }
            Gateway gateway = (Gateway)holder.get();
            return gateway.createEntity((Level)world, (Player)randomPlayer);
        }
        catch (Exception e) {
            LOGGER.error("PlaGateSummon: Failed to get gateway id: {}", (Object)gatewayId);
            return null;
        }
    }

    static void spawnGateway(ServerLevel world, BlockPos pos, String gatewayId, GateSpawnData data) {
        try {
            ResourceLocation type = new ResourceLocation(gatewayId);
            DynamicHolder holder = GatewayRegistry.INSTANCE.holder(type);
            if (!holder.isBound()) {
                LOGGER.error("PlaGateSummon: Unknown Gateway: {}", (Object)gatewayId);
            }
            Gateway gateway = (Gateway)holder.get();
            GatewayEntity entity = gateway.createEntity((Level)world, (Player)randomPlayer);
            entity.m_20219_(Vec3.m_82512_((Vec3i)pos));
            world.m_7967_((Entity)entity);
            entity.getPersistentData().m_128385_("GateSpawnPos", new int[]{data.spawnPos.m_123341_(), data.spawnPos.m_123342_(), data.spawnPos.m_123343_()});
            entity.getPersistentData().m_128359_("GateWaypointName", data.waypointName);
            entity.onGateCreated();
        }
        catch (Exception e) {
            LOGGER.error("PlaGateSummon: Failed to spawn gateway: {}", (Object)gatewayId);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ServerLevel world = server.m_129880_(Level.f_46428_);
        if (world == null || !world.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        GateSpawnData data = GateSpawnData.get(world);
        randomPlayer = world.m_8890_();
        boolean debug_mode = (Boolean)Config.DEBUG_MODE.get();
        if (randomPlayer == null) {
            return;
        }
        source = randomPlayer.m_20203_();
        source = new CommandSourceStack((CommandSource)Objects.requireNonNull(source.m_81373_()), source.m_81371_(), source.m_81376_(), source.m_81372_(), 4, source.m_81368_(), source.m_81357_(), source.m_81377_(), source.m_81373_());
        long dayTime = world.m_46468_() % 24000L;
        if (dayTime == 1L) {
            if (data.skippedToday) {
                data.skippedToday = false;
                data.m_77762_();
            } else if (data.spawnPos == null) {
                int spawn_day = (Integer)Config.SPAWN_DAY.get();
                if (spawn_day != 0) {
                    if (debug_mode) {
                        LOGGER.info("PlaGateSummon: day passed: " + data.dayPassed + " gate will be spawned in " + (spawn_day - data.dayPassed) + " day(s)");
                    }
                    if (data.dayPassed == spawn_day) {
                        DailyGateSpawner.prepareForSpawning(data, world, server, source, debug_mode);
                    } else {
                        data.shouldSpawnToday = false;
                        ++data.dayPassed;
                        data.m_77762_();
                        if (debug_mode) {
                            LOGGER.info("PlaGateSummon: No gate will be spawned today");
                        }
                    }
                } else {
                    int randomPercentage = random.nextInt(100);
                    if (debug_mode) {
                        LOGGER.info("PlaGateSummon: randomPercentage is " + randomPercentage + " the spawnChance is " + data.spawnChance);
                    }
                    if (randomPercentage < data.spawnChance) {
                        DailyGateSpawner.prepareForSpawning(data, world, server, source, debug_mode);
                    } else {
                        data.shouldSpawnToday = false;
                        data.spawnChance += ((Integer)Config.SPAWN_RATE.get()).intValue();
                        data.m_77762_();
                        if (debug_mode) {
                            LOGGER.info("PlaGateSummon: No gate will be spawned today");
                        }
                        return;
                    }
                }
            }
        }
        if (!data.shouldSpawnToday) {
            return;
        }
        long remainingTick = (long)data.nextSpawnTick - dayTime;
        if (remainingTick < -6000L && data.spawnPos != null && data.spawnPos.m_123342_() == 0) {
            DailyGateSpawner.resetValue(data, false);
        } else if (remainingTick <= 0L && data.spawnPos != null) {
            if (data.spawnPos.m_123342_() == 0 && SurfaceSpawnHelper.isChunkLoaded(world, data.spawnPos)) {
                data.spawnPos = SurfaceSpawnHelper.moveToSurface(world, data.spawnPos);
                data.m_77762_();
                return;
            }
            DailyGateSpawner.spawnGateway(world, data.spawnPos, data.randomGate, data);
            DailyGateSpawner.resetValue(data, true);
        } else if (remainingTick <= 6000L) {
            if (!data.isPromptPlayer) {
                List gates = (List)Config.GATES.get();
                String randomGateId = (String)gates.get(world.f_46441_.m_188503_(gates.size()));
                GatewayEntity gatewayEntity = DailyGateSpawner.getGateway(world, randomGateId);
                if (gatewayEntity == null) {
                    return;
                }
                data.randomGate = randomGateId;
                data.hexColor = 0xFF000000 | gatewayEntity.getGateway().color().m_131265_() & 0xFFFFFF;
                data.mainMessage = "A " + gatewayEntity.m_5446_().getString() + " is going to spawn";
                data.subMessage = "Be ready to fight!";
                data.waypointName = gatewayEntity.m_5446_().getString();
                data.m_77762_();
                WaypointHelper.createWaypoint(data.spawnPos, data.waypointName, data.hexColor);
                String addWaypoint = "waypoint create \"" + data.waypointName + "\" minecraft:overworld " + data.spawnPos.m_123341_() + " " + data.spawnPos.m_123342_() + " " + data.spawnPos.m_123343_() + " dark_purple @a";
                try {
                    Objects.requireNonNull(randomPlayer.m_20194_()).m_129892_().m_82094_().execute(addWaypoint, (Object)source);
                }
                catch (CommandSyntaxException e) {
                    LOGGER.warn("PlaGateSummon: (Journey Map Compat) Failed to execute command {}, error {}", (Object)addWaypoint, (Object)e);
                }
                data.isPromptPlayer = true;
                data.m_77762_();
            }
            assert (data.spawnPos != null);
            if (data.spawnPos.m_123342_() == 0 && SurfaceSpawnHelper.isChunkLoaded(world, data.spawnPos)) {
                data.spawnPos = SurfaceSpawnHelper.moveToSurface(world, data.spawnPos);
                data.m_77762_();
            }
            List players = world.m_6907_();
            for (Player player : players) {
                if (player.m_9236_().m_5776_()) continue;
                player.m_5661_((Component)Component.m_237113_((String)(data.mainMessage + " at x: " + data.spawnPos.m_123341_() + " z: " + data.spawnPos.m_123343_() + " in " + remainingTick / 20L + " seconds! " + data.subMessage)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)(data.hexColor & 0xFFFFFF)))), true);
            }
        }
    }
}

