/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plagatesummon.mixin;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.plagatesummon.ClaimChunkHelper;
import com.pla.plagatesummon.DailyGateSpawner;
import com.pla.plagatesummon.WaypointHelper;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GatewayEntity.class}, remap=false)
public class GatewayEntityMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    private void cleanUp(GatewayEntity gatewayEntity) {
        CompoundTag tag = gatewayEntity.getPersistentData();
        if (tag.m_128441_("GateSpawnPos")) {
            int[] posArr = tag.m_128465_("GateSpawnPos");
            BlockPos spawnPos = new BlockPos(posArr[0], posArr[1], posArr[2]);
            try {
                ClaimChunkHelper claimChunkHelper = ClaimChunkHelper.getInstance(gatewayEntity.m_20194_());
                if (tag.m_128441_("CleanUpAction") && tag.m_128441_("UnClaimUUID")) {
                    switch (tag.m_128461_("CleanUpAction")) {
                        case "full": {
                            claimChunkHelper.unClaimChunk(DailyGateSpawner.source, spawnPos, tag.m_128342_("UnClaimUUID"), gatewayEntity);
                            claimChunkHelper.unForceLoadChunk(DailyGateSpawner.source, spawnPos, tag.m_128342_("UnClaimUUID"), gatewayEntity);
                            break;
                        }
                        case "half": {
                            claimChunkHelper.unForceLoadChunk(DailyGateSpawner.source, spawnPos, tag.m_128342_("UnClaimUUID"), gatewayEntity);
                            break;
                        }
                    }
                }
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("PlaGateSummon: Failed to unclaim chunk on spawn");
            }
        }
        WaypointHelper.removeWaypoint(tag.m_128461_("GateWaypointName"));
        String clearWaypoint = "waypoint delete \"" + tag.m_128461_("GateWaypointName") + "\" @a";
        try {
            Objects.requireNonNull(DailyGateSpawner.randomPlayer.m_20194_()).m_129892_().m_82094_().execute(clearWaypoint, (Object)DailyGateSpawner.source);
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn("PlaGateSummon: (Journey Map Compat) Failed to execute command {}, error {}", (Object)clearWaypoint, (Object)e);
        }
    }

    @Inject(method={"onGateCreated"}, at={@At(value="HEAD")})
    private void claimChunkOnSpawn(CallbackInfo ci) {
        GatewayEntity self = (GatewayEntity)this;
        CompoundTag tag = self.getPersistentData();
        if (tag.m_128441_("GateSpawnPos")) {
            int[] posArr = tag.m_128465_("GateSpawnPos");
            BlockPos spawnPos = new BlockPos(posArr[0], posArr[1], posArr[2]);
            try {
                ClaimChunkHelper claimChunkHelper = ClaimChunkHelper.getInstance(self.m_20194_());
                claimChunkHelper.processClaim(DailyGateSpawner.source, DailyGateSpawner.randomPlayer, spawnPos, self);
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("PlaGateSummon: Failed to claim chunk on spawn");
            }
        }
    }

    @Inject(method={"completeGateway"}, at={@At(value="HEAD")})
    private void cleanupOnComplete(CallbackInfo ci) {
        GatewayEntity self = (GatewayEntity)this;
        this.cleanUp(self);
    }

    @Inject(method={"onFailure"}, at={@At(value="HEAD")})
    private void cleanupOnFailure(Collection<LivingEntity> remaining, GatewayEntity.FailureReason reason, CallbackInfo ci) {
        GatewayEntity self = (GatewayEntity)this;
        this.cleanUp(self);
    }
}

