/*
 * Decompiled with CFR 0.152.
 */
package Commands;

import Utils.ConfigManagement;
import Utils.KudosUtils.KudosAward;
import Utils.KudosUtils.KudosLimitation;
import Utils.KudosUtils.KudosManagement;
import Utils.KudosUtils.KudosMessage;
import Utils.KudosUtils.KudosMilestone;
import Utils.UrbanceDebug;
import Utils.WorkaroundManagement;
import de.urbance.Main;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class Kudo
implements CommandExecutor,
TabCompleter {
    private Main plugin;
    private KudosMessage kudosMessage;
    private KudosManagement kudosManagement;
    private FileConfiguration locale;
    private FileConfiguration config;
    private final KudosLimitation kudosLimitation = new KudosLimitation();

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (WorkaroundManagement.isLegacyConfig || WorkaroundManagement.isSQLMigrationNeeded || WorkaroundManagement.isConfigMigrationNeeded) {
            return false;
        }
        this.plugin = (Main)Main.getPlugin(Main.class);
        this.locale = ConfigManagement.getLocalesConfig();
        this.config = ConfigManagement.getConfig();
        this.kudosMessage = new KudosMessage(this.plugin);
        this.kudosManagement = new KudosManagement();
        String reason = null;
        if (this.config.getBoolean("kudo-award.general-settings.enable-reasons") && args.length > 1) {
            reason = this.kudosManagement.getReason(args, 2);
        }
        if (!this.validateInput(args, sender, reason)) {
            return false;
        }
        this.awardKudo(sender, args, reason);
        return false;
    }

    private void awardKudo(CommandSender sender, String[] args, String reason) {
        Player targetPlayer = Bukkit.getPlayer((String)args[0]);
        UUID targetPlayerUUID = targetPlayer.getUniqueId();
        if (!this.playerCanReceiveKudo(sender, targetPlayer)) {
            return;
        }
        if (this.kudosManagement.isMilestone(targetPlayer) ? !new KudosMilestone().sendMilestone(sender, targetPlayer, reason) : !new KudosAward().sendKudoAward(sender, targetPlayer, reason)) {
            return;
        }
    }

    private boolean playerCanReceiveKudo(CommandSender sender, Player targetPlayer) {
        if (!this.validatePlayerCooldown(sender)) {
            return false;
        }
        return !this.config.getBoolean("kudo-award.limitation.enabled") || this.kudosLimitation.setLimitation(sender, targetPlayer);
    }

    private boolean validateInput(String[] args, CommandSender sender, String reason) {
        if (!sender.hasPermission("kudos.player.award") && !sender.hasPermission("kudos.player.*")) {
            this.kudosMessage.noPermission(sender);
            return false;
        }
        if (args.length == 0) {
            this.kudosMessage.sendSender(sender, this.locale.getString("error.specify-player"));
            return false;
        }
        if (Bukkit.getPlayer((String)args[0]) == null) {
            HashMap<String, String> placeholderValues = new HashMap<String, String>();
            placeholderValues.put("kudos_targetplayer_name", args[0]);
            this.kudosMessage.sendSender(sender, this.kudosMessage.setPlaceholders(this.locale.getString("error.player-not-online"), placeholderValues));
            return false;
        }
        if (sender == Bukkit.getPlayer((String)args[0])) {
            this.kudosMessage.sendSender(sender, this.locale.getString("error.cant-give-yourself-kudo"));
            return false;
        }
        if (args.length > 1) {
            if (this.config.getBoolean("kudo-award.general-settings.enable-reasons")) {
                int maximumReasonLength = this.config.getInt("kudo-award.general-settings.reason-length");
                if (reason.length() < maximumReasonLength) {
                    return true;
                }
                this.kudosMessage.sendSender(sender, this.locale.getString("error.award-reason-is-too-long").replace("%kudos_maximum_award_reason_chars%", String.valueOf(maximumReasonLength)));
                return false;
            }
            this.kudosMessage.wrongUsage(sender);
            return false;
        }
        return true;
    }

    private boolean validatePlayerCooldown(CommandSender sender) {
        UrbanceDebug.sendInfo("Step: Kudos.Award.Validate.Cooldown");
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        UUID senderUUID = ((Player)sender).getUniqueId();
        UrbanceDebug.sendInfo(sender.getName() + " kudos to a player");
        UrbanceDebug.sendInfo("senderUUID: " + String.valueOf(senderUUID));
        UrbanceDebug.sendInfo("Date: " + String.valueOf(LocalDateTime.now()));
        int totalAwardedKudos = this.plugin.data.getTotalAwardedKudos(senderUUID);
        if (totalAwardedKudos == -1) {
            this.kudosMessage.sendSender(sender, this.locale.getString("error.something-went-wrong-please-contact-server-administrator"));
            return false;
        }
        UrbanceDebug.sendInfo("totalAwardedKudos: " + totalAwardedKudos);
        if (totalAwardedKudos == 0) {
            return true;
        }
        String stringLastKudoAwardedAt = this.plugin.data.getLastKudoAwardedDateFromPlayer(senderUUID);
        if (stringLastKudoAwardedAt == null) {
            this.kudosMessage.sendSender(sender, this.locale.getString("error.something-went-wrong-please-contact-server-administrator"));
            return false;
        }
        DateTimeFormatter dateFormat = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime lastKudoAwardedAt = LocalDateTime.parse(stringLastKudoAwardedAt, dateFormat);
        LocalDateTime nextKudoCanAwardedAt = lastKudoAwardedAt.plusSeconds(this.config.getLong("kudo-award.general-settings.cooldown"));
        UrbanceDebug.sendInfo("lastKudoAwardedAt: " + String.valueOf(lastKudoAwardedAt));
        UrbanceDebug.sendInfo("nextKudoCanAwardedAt:  " + String.valueOf(nextKudoCanAwardedAt));
        if (LocalDateTime.now().isAfter(nextKudoCanAwardedAt)) {
            return true;
        }
        Long secondsUntilNextKudoCanAwarded = Duration.between(LocalDateTime.now(), nextKudoCanAwardedAt).getSeconds();
        if (secondsUntilNextKudoCanAwarded >= 0L) {
            UrbanceDebug.sendInfo("secondsUntilNextKudoCanAwarded: " + secondsUntilNextKudoCanAwarded);
            HashMap<String, String> placeholderValues = new HashMap<String, String>();
            placeholderValues.put("kudos_cooldown", String.valueOf(secondsUntilNextKudoCanAwarded));
            this.kudosMessage.sendSender(sender, this.kudosMessage.setPlaceholders(this.locale.getString("error.must-wait-before-use-again"), placeholderValues));
            return false;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> commandArguments = new ArrayList<String>();
        ArrayList<String> tabCompletions = new ArrayList<String>();
        FileConfiguration config = ((Main)Main.getPlugin(Main.class)).config;
        if (!sender.hasPermission("kudos.player.award") && !sender.hasPermission("kudos.player.*")) {
            return commandArguments;
        }
        if (WorkaroundManagement.isConfigMigrationNeeded) {
            return tabCompletions;
        }
        switch (args.length) {
            case 1: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    commandArguments.add(player.getName());
                }
                StringUtil.copyPartialMatches((String)args[0], commandArguments, tabCompletions);
                break;
            }
            case 2: {
                if (config.getBoolean("kudo-award.general-settings.enable-reasons")) {
                    tabCompletions.add("reason");
                }
                StringUtil.copyPartialMatches((String)args[1], commandArguments, tabCompletions);
            }
        }
        return tabCompletions;
    }
}

