/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.GUI_Interface;
import GUI.OverviewGUI;
import Utils.ConfigManagement;
import Utils.ItemCreator;
import Utils.KudosUtils.KudosMessage;
import Utils.KudosUtils.UrbanceGUI;
import de.urbance.Main;
import de.urbance.shaded.inventoryframework.gui.GuiItem;
import de.urbance.shaded.inventoryframework.gui.type.ChestGui;
import de.urbance.shaded.inventoryframework.pane.StaticPane;
import de.urbance.shaded.inventoryframework.pane.util.Slot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class LeaderboardGUI
implements GUI_Interface {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private StaticPane staticPane;
    private Player player;
    private ChestGui gui;
    private HashMap<UUID, String> leaderboardData;

    public LeaderboardGUI(HashMap<UUID, String> leaderboardData) {
        this.leaderboardData = leaderboardData;
    }

    private void init() {
        this.createGUI();
        this.fillGUI();
    }

    private void fillGUI() {
        this.staticPane = new StaticPane(0, 0, 9, 1);
        this.setBackwardsPageSwitcher();
        this.setLeaderboardPlayers();
        this.gui.addPane(this.staticPane);
    }

    private void createGUI() {
        FileConfiguration globalGuiSettingsConfig = ConfigManagement.getGlobalGuiSettingsConfig();
        String guiTitle = globalGuiSettingsConfig.getString("general-settings.gui-title");
        this.gui = new UrbanceGUI().create(guiTitle, 1).cancelOnGlobalClick(true).get();
    }

    private void setBackwardsPageSwitcher() {
        UrbanceGUI urbanceGUI = new UrbanceGUI();
        GuiItem backwardsPageSwitcher = urbanceGUI.getBackwardsPageSwitcher();
        backwardsPageSwitcher.setAction(inventoryClickEvent -> {
            new OverviewGUI().open(this.player);
            urbanceGUI.playsoundPageSwitcher(this.player);
        });
        this.staticPane.addItem(backwardsPageSwitcher, Slot.fromIndex(0));
    }

    private void setLeaderboardPlayers() {
        FileConfiguration leaderboardConfig = ConfigManagement.getLeaderboardGuiConfig();
        int playerHeadSlot = 2;
        for (UUID entry : this.leaderboardData.keySet()) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)entry);
            String playerTotalKudos = this.leaderboardData.get(entry);
            String itemDisplayName = leaderboardConfig.getString("items.player-leaderboard-item.item-name").replace("%kudos_leaderboard_name%", player.getName());
            List itemLore = leaderboardConfig.getStringList("items.player-leaderboard-item.item-lore");
            ArrayList<String> modifiedItemLore = new ArrayList<String>();
            for (String itemLoreEntry : itemLore) {
                itemLoreEntry = itemLoreEntry.replace("%kudos_leaderboard_kudos%", playerTotalKudos);
                modifiedItemLore.add(itemLoreEntry);
            }
            ItemCreator itemCreator = new ItemCreator("PLAYER_HEAD");
            GuiItem playerHead = new GuiItem(itemCreator.setDisplayName(itemDisplayName).setLore(modifiedItemLore).replaceSkullWithPlayerSkull(player).get());
            this.staticPane.addItem(playerHead, Slot.fromIndex(playerHeadSlot));
            ++playerHeadSlot;
        }
    }

    @Override
    public void open(Player player) {
        this.player = player;
        this.init();
        if (this.gui == null) {
            String errorMessage = ConfigManagement.getLocalesConfig().getString("error.something-went-wrong-please-contact-server-administrator");
            if (player != null) {
                new KudosMessage(this.plugin).send(player, errorMessage);
            }
            return;
        }
        this.gui.show((HumanEntity)player);
    }
}

