/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.LeaderboardGUI;
import GUI.ReceivedKudosGUI;
import Utils.ConfigManagement;
import Utils.ItemCreator;
import Utils.KudosUtils.KudosMessage;
import Utils.KudosUtils.UrbanceGUI;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import de.urbance.shaded.inventoryframework.gui.GuiItem;
import de.urbance.shaded.inventoryframework.gui.type.ChestGui;
import de.urbance.shaded.inventoryframework.pane.StaticPane;
import de.urbance.shaded.inventoryframework.pane.util.Slot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class OverviewGUI
implements Listener {
    private final Main plugin = (Main)Main.getPlugin(Main.class);
    private final SQLGetter data;
    private final FileConfiguration overviewConfig;
    private ChestGui kudosGUI;
    private Player player;
    private StaticPane overviewPane;

    public OverviewGUI() {
        this.data = this.plugin.data;
        this.overviewConfig = ConfigManagement.getOverviewGuiConfig();
    }

    private void createOverviewGui() {
        FileConfiguration globalGuiSettingsConfig = ConfigManagement.getGlobalGuiSettingsConfig();
        String guiTitle = globalGuiSettingsConfig.getString("general-settings.gui-title");
        int size = this.overviewConfig.getInt("general-settings.rows");
        if (size < 1 || size > 6) {
            this.plugin.getLogger().warning("Error: Please set the value for the key \"rows\" in the overview.yml between 1 and 6.");
            return;
        }
        this.kudosGUI = new UrbanceGUI().create(guiTitle, size).cancelOnGlobalClick(true).get();
        this.createAndSetPane();
    }

    private void createAndSetPane() {
        this.overviewPane = new StaticPane(0, 0, 9, this.kudosGUI.getRows());
        this.addStatisticsGuiItem();
        this.addHelpGuiItem();
        this.addLeaderboardGuiItem();
        this.addReceivedKudosGuiItem();
        this.kudosGUI.addPane(this.overviewPane);
    }

    private void addStatisticsGuiItem() {
        if (this.overviewConfig.getBoolean("items.statistics.enabled")) {
            ItemCreator statisticsItemItemStack = new ItemCreator(this.overviewConfig.getString("items.statistics.item")).setDisplayName(this.overviewConfig.getString("items.statistics.item-name")).setLore(this.setStatisticsValuesLore(this.overviewConfig.getStringList("items.statistics.item-lore"), this.player)).replaceSkullWithPlayerSkull((OfflinePlayer)this.player);
            GuiItem guiItem = new GuiItem(statisticsItemItemStack.get());
            this.overviewPane.addItem(guiItem, Slot.fromIndex(this.overviewConfig.getInt("items.statistics.item-slot")));
        }
    }

    private void addHelpGuiItem() {
        if (this.overviewConfig.getBoolean("items.help.enabled")) {
            ItemCreator helpItemItemStack = new ItemCreator(this.overviewConfig.getString("items.help.item")).setDisplayName(this.overviewConfig.getString("items.help.item-name")).setLore(this.overviewConfig.getStringList("items.help.item-lore")).replaceSkullWithPlayerSkull((OfflinePlayer)this.player);
            GuiItem helpItem = new GuiItem(helpItemItemStack.get());
            this.overviewPane.addItem(helpItem, Slot.fromIndex(this.overviewConfig.getInt("items.help.item-slot")));
        }
    }

    private void addLeaderboardGuiItem() {
        if (this.overviewConfig.getBoolean("items.kudos-leaderboard.enabled")) {
            HashMap<UUID, String> leaderboardTopKudosData = this.data.getTopPlayersKudos(6);
            List lore = this.overviewConfig.getStringList("items.kudos-leaderboard.item-lore");
            if (leaderboardTopKudosData.isEmpty()) {
                lore = this.overviewConfig.getStringList("items.kudos-leaderboard.item-lore-no-kudos-exists");
            }
            ItemCreator leaderboardItemItemStack = new ItemCreator(this.overviewConfig.getString("items.kudos-leaderboard.item")).setDisplayName(this.overviewConfig.getString("items.kudos-leaderboard.item-name")).setLore(lore).replaceSkullWithPlayerSkull((OfflinePlayer)this.player);
            GuiItem leaderboardItem = new GuiItem(leaderboardItemItemStack.get(), event -> {
                if (leaderboardTopKudosData.isEmpty()) {
                    return;
                }
                new LeaderboardGUI(leaderboardTopKudosData).open(this.player);
            });
            this.overviewPane.addItem(leaderboardItem, Slot.fromIndex(this.overviewConfig.getInt("items.kudos-leaderboard.item-slot")));
        }
    }

    private void addReceivedKudosGuiItem() {
        if (this.overviewConfig.getBoolean("items.received-kudos.enabled")) {
            List lore = this.overviewConfig.getStringList("items.received-kudos.item-lore-no-received-kudos");
            if (this.data.getAmountKudos(this.player.getUniqueId()) > 0) {
                lore = this.overviewConfig.getStringList("items.received-kudos.item-lore");
            }
            ItemCreator receivedKudosItemItemCreator = new ItemCreator(this.overviewConfig.getString("items.received-kudos.item")).setDisplayName(this.overviewConfig.getString("items.received-kudos.item-name")).setLore(lore);
            GuiItem receivedKudosItem = new GuiItem(receivedKudosItemItemCreator.get(), event -> {
                HashMap<Integer, String> receivedKudosList = this.data.getPlayerReceivedKudosGUI(this.player.getUniqueId());
                if (receivedKudosList.isEmpty()) {
                    return;
                }
                this.openReceivedKudosGUI();
            });
            this.overviewPane.addItem(receivedKudosItem, Slot.fromIndex(this.overviewConfig.getInt("items.received-kudos.item-slot")));
        }
    }

    private List<String> setStatisticsValuesLore(List<String> lore, Player player) {
        if (lore == null) {
            return null;
        }
        ArrayList<String> modifiedLore = new ArrayList<String>();
        for (String entry : lore) {
            entry = ChatColor.translateAlternateColorCodes((char)'&', (String)entry);
            if (player != null) {
                entry = entry.replace("%kudos_player_kudos%", String.valueOf(this.data.getAmountKudos(player.getUniqueId())));
                entry = entry.replace("%kudos_player_assigned_kudos%", String.valueOf(this.data.getAssignedKudos(player.getUniqueId())));
            }
            modifiedLore.add(entry);
        }
        return modifiedLore;
    }

    private void openReceivedKudosGUI() {
        new ReceivedKudosGUI().open(this.player);
    }

    public void open(Player player) {
        this.player = player;
        this.createOverviewGui();
        if (this.kudosGUI == null) {
            String errorMessage = ConfigManagement.getLocalesConfig().getString("error.something-went-wrong-please-contact-server-administrator");
            if (player != null) {
                new KudosMessage(this.plugin).send(player, errorMessage);
            }
            return;
        }
        this.kudosGUI.show((HumanEntity)player);
    }
}

