/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import de.urbance.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManagement {
    private static final HashMap<String, String> configPathMapping = new HashMap();
    private static HashMap<String, FileConfiguration> configFiles = new HashMap();
    public String fileName;
    public String fullFileName;
    public FileConfiguration fileConfiguration;
    public Main plugin;
    public File file;

    public ConfigManagement(String fileName, Main plugin) {
        this.fileName = fileName;
        this.fullFileName = configPathMapping.getOrDefault(fileName, fileName);
        this.fileConfiguration = configFiles.get(fileName);
        this.plugin = plugin;
        this.saveDefaultConfig();
    }

    public static void initConfigFiles(Main plugin) {
        configPathMapping.put("config.yml", "config.yml");
        configPathMapping.put("mysql.yml", "mysql.yml");
        configPathMapping.put("messages.yml", "messages.yml");
        configPathMapping.put("overview.yml", "guis" + File.separator + "overview.yml");
        configPathMapping.put("global-gui-settings.yml", "guis" + File.separator + "global-gui-settings.yml");
        configPathMapping.put("leaderboard.yml", "guis" + File.separator + "leaderboard.yml");
        configPathMapping.put("received-kudos.yml", "guis" + File.separator + "received-kudos.yml");
        ConfigManagement.reloadAllConfigs(plugin);
    }

    public static FileConfiguration getConfig() {
        Main plugin = (Main)Main.getPlugin(Main.class);
        ConfigManagement configManagement = new ConfigManagement("config.yml", plugin);
        return configManagement.getFileConfiguration();
    }

    public static FileConfiguration getMySQLConfig() {
        Main plugin = (Main)Main.getPlugin(Main.class);
        ConfigManagement configManagement = new ConfigManagement("mysql.yml", plugin);
        return configManagement.getFileConfiguration();
    }

    public static FileConfiguration getLocalesConfig() {
        Main plugin = (Main)Main.getPlugin(Main.class);
        ConfigManagement configManagement = new ConfigManagement("messages.yml", plugin);
        return configManagement.getFileConfiguration();
    }

    public static FileConfiguration getOverviewGuiConfig() {
        Main plugin = (Main)Main.getPlugin(Main.class);
        ConfigManagement configManagement = new ConfigManagement("overview.yml", plugin);
        return configManagement.getFileConfiguration();
    }

    public static FileConfiguration getGlobalGuiSettingsConfig() {
        Main plugin = (Main)Main.getPlugin(Main.class);
        ConfigManagement configManagement = new ConfigManagement("global-gui-settings.yml", plugin);
        return configManagement.getFileConfiguration();
    }

    public static FileConfiguration getLeaderboardGuiConfig() {
        Main plugin = (Main)Main.getPlugin(Main.class);
        ConfigManagement configManagement = new ConfigManagement("leaderboard.yml", plugin);
        return configManagement.getFileConfiguration();
    }

    public static FileConfiguration getReceivedKudosGuiConfig() {
        Main plugin = (Main)Main.getPlugin(Main.class);
        ConfigManagement configManagement = new ConfigManagement("received-kudos.yml", plugin);
        return configManagement.getFileConfiguration();
    }

    public static void reloadAllConfigs(Main plugin) {
        for (String configFileName : configPathMapping.keySet()) {
            ConfigManagement configManagement = new ConfigManagement(configFileName, plugin);
            configManagement.reload();
            if (!configFileName.equals("config.yml")) continue;
            FileConfiguration config = configManagement.getFileConfiguration();
            plugin.prefix = config.getString("general-settings.prefix");
            plugin.config = config;
        }
    }

    public FileConfiguration getFileConfiguration() {
        if (this.fileConfiguration == null) {
            this.reload();
        }
        return this.fileConfiguration;
    }

    public void reload() {
        if (this.fileConfiguration == null) {
            this.file = new File(this.plugin.getDataFolder(), this.fullFileName);
        }
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        InputStream defaultStream = this.plugin.getResource(this.fullFileName);
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.fileConfiguration.setDefaults((Configuration)defaultConfig);
            this.fileConfiguration.options().copyDefaults(true);
            this.save();
        }
        configFiles.put(this.fileName, this.fileConfiguration);
    }

    public void save() {
        if (this.file == null) {
            this.saveDefaultConfig();
        }
        if (this.fileConfiguration == null) {
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveDefaultConfig() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), this.fullFileName);
        }
        if (!this.file.exists()) {
            this.plugin.saveResource(this.fullFileName, false);
        }
    }

    public boolean deleteConfigFile() {
        return this.file.delete();
    }

    public boolean createBackup() {
        String fileNameWithoutFileExtension = this.fileName.substring(0, this.fileName.indexOf("."));
        Path sourcePath = this.file.toPath();
        Path targetPath = this.file.getParentFile().toPath().resolve(fileNameWithoutFileExtension + "-backup.yml.");
        int backupFileCounter = 2;
        while (Files.exists(targetPath, new LinkOption[0])) {
            targetPath = this.file.getParentFile().toPath().resolve(fileNameWithoutFileExtension + "-backup-" + backupFileCounter + ".yml");
            ++backupFileCounter;
        }
        try {
            Files.copy(sourcePath, targetPath, new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Cannot create backup file from " + this.fileName + ". " + e.getMessage());
            return false;
        }
    }

    public static void copyConfigValuesBetweenTwoConfigs(Map<String, String> configKeys, FileConfiguration fromConfig, FileConfiguration toConfig) {
        for (String oldConfigKey : fromConfig.getKeys(true)) {
            if (!configKeys.containsKey(oldConfigKey)) continue;
            String newConfigKey = configKeys.get(oldConfigKey);
            Object configKeyValue = fromConfig.get(oldConfigKey);
            toConfig.set(newConfigKey, configKeyValue);
        }
    }
}

