/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import de.urbance.Main;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class ItemCreator {
    private ItemStack itemStack;
    private ItemMeta itemMeta;
    private int amount;
    Main plugin = (Main)Main.getPlugin(Main.class);

    public ItemCreator(String material) {
        this.itemStack = new ItemStack(Material.valueOf((String)material));
        this.itemMeta = this.itemStack.getItemMeta();
        this.amount = 1;
    }

    public ItemCreator setDisplayName(String displayName) {
        this.itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
        return this;
    }

    public ItemCreator setAmount(int amount) {
        this.amount = amount;
        this.itemStack.setAmount(this.amount);
        return this;
    }

    public ItemCreator setLore(List<String> lore) {
        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        this.itemMeta.setLore(lore);
        return this;
    }

    public ItemCreator replaceSkullWithPlayerSkull(OfflinePlayer offlinePlayer) {
        if (this.itemStack.getType() != Material.PLAYER_HEAD) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.itemStack.getItemMeta();
        skullMeta.setOwningPlayer(offlinePlayer);
        skullMeta.setDisplayName(this.itemMeta.getDisplayName());
        skullMeta.setLore(this.itemMeta.getLore());
        this.itemMeta = skullMeta;
        return this;
    }

    public ItemCreator replaceSkullWithCustomURLSkull(String url) {
        URL urlObject;
        if (this.itemStack.getType() != Material.PLAYER_HEAD) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.itemMeta;
        UUID uuid = UUID.randomUUID();
        PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)uuid, (String)uuid.toString().substring(0, 16));
        PlayerTextures playerTextures = playerProfile.getTextures();
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException e) {
            this.plugin.getLogger().warning("An error occurred! Please report the error to the plugin developer:");
            e.printStackTrace();
            return this;
        }
        playerTextures.setSkin(urlObject);
        playerProfile.setTextures(playerTextures);
        skullMeta.setOwnerProfile(playerProfile);
        this.itemMeta = skullMeta;
        return this;
    }

    public ItemStack get() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }
}

