/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class KudosExpansion
extends PlaceholderExpansion {
    public String getIdentifier() {
        return "kudos";
    }

    public String getAuthor() {
        return "Urbance";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getRequiredPlugin() {
        return "Kudos";
    }

    public String onRequest(OfflinePlayer player, String parameter) {
        if (player == null) {
            return "KUDOS_PLACEHOLDER_PLAYER_NOT_FOUND";
        }
        Main plugin = (Main)Main.getPlugin(Main.class);
        SQLGetter data = new SQLGetter(plugin);
        UUID playerUUID = player.getUniqueId();
        String notAssignedKudos = ConfigManagement.getGlobalGuiSettingsConfig().getString("placeholderapi-settings.items.kudos-leaderboard.item-lore-not-assigned-kudos");
        List<String> topPlayerKudos = data.getTopPlayersKudosTemp();
        switch (parameter) {
            case "player_name": {
                return player.getName();
            }
            case "player_kudos": {
                return String.valueOf(data.getAmountKudos(playerUUID));
            }
            case "player_assigned_kudos": {
                return String.valueOf(data.getAssignedKudos(playerUUID));
            }
            case "top1_kudos": {
                if (topPlayerKudos.isEmpty()) {
                    return notAssignedKudos;
                }
                return topPlayerKudos.get(0);
            }
            case "top2_kudos": {
                if (topPlayerKudos.size() < 2) {
                    return notAssignedKudos;
                }
                return topPlayerKudos.get(1);
            }
            case "top3_kudos": {
                if (topPlayerKudos.size() < 3) {
                    return notAssignedKudos;
                }
                return topPlayerKudos.get(2);
            }
        }
        return null;
    }
}

