/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import de.urbance.Main;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class KudosMessage {
    private String prefix;
    private FileConfiguration locale;

    public KudosMessage(Main plugin) {
        this.prefix = plugin.prefix;
        this.locale = ConfigManagement.getLocalesConfig();
    }

    public void send(Player player, String message) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + message)));
    }

    public void sendSender(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + message)));
    }

    public void broadcast(String message) {
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + message)));
    }

    public void noPermission(CommandSender sender) {
        this.sendSender(sender, this.locale.getString("error.no-permission"));
    }

    public void wrongUsage(CommandSender sender) {
        this.sendSender(sender, this.locale.getString("error.wrong-usage"));
    }

    public String setPlaceholders(String message, Map<String, String> values) {
        return StringSubstitutor.replace(message, values, "%", "%");
    }

    public static String formatStringForConsole(String message) {
        return "\n " + message.replaceAll("&.", "");
    }
}

